/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResourceHydrationAccount
implements JsonSerializable<ResourceHydrationAccount> {
    private Long maxChildResourceConsistencyJobLimit;
    private String encryptedKey;
    private String accountName;
    private String subscriptionId;

    public Long maxChildResourceConsistencyJobLimit() {
        return this.maxChildResourceConsistencyJobLimit;
    }

    public ResourceHydrationAccount withMaxChildResourceConsistencyJobLimit(Long maxChildResourceConsistencyJobLimit) {
        this.maxChildResourceConsistencyJobLimit = maxChildResourceConsistencyJobLimit;
        return this;
    }

    public String encryptedKey() {
        return this.encryptedKey;
    }

    public ResourceHydrationAccount withEncryptedKey(String encryptedKey) {
        this.encryptedKey = encryptedKey;
        return this;
    }

    public String accountName() {
        return this.accountName;
    }

    public ResourceHydrationAccount withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public ResourceHydrationAccount withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxChildResourceConsistencyJobLimit", (Number)this.maxChildResourceConsistencyJobLimit);
        jsonWriter.writeStringField("encryptedKey", this.encryptedKey);
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        return jsonWriter.writeEndObject();
    }

    public static ResourceHydrationAccount fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceHydrationAccount)jsonReader.readObject(reader -> {
            ResourceHydrationAccount deserializedResourceHydrationAccount = new ResourceHydrationAccount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxChildResourceConsistencyJobLimit".equals(fieldName)) {
                    deserializedResourceHydrationAccount.maxChildResourceConsistencyJobLimit = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("encryptedKey".equals(fieldName)) {
                    deserializedResourceHydrationAccount.encryptedKey = reader.getString();
                    continue;
                }
                if ("accountName".equals(fieldName)) {
                    deserializedResourceHydrationAccount.accountName = reader.getString();
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedResourceHydrationAccount.subscriptionId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceHydrationAccount;
        });
    }
}

