/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.OptInHeaderType;
import com.azure.resourcemanager.providerhub.models.OptOutHeaderType;
import java.io.IOException;

public class RequestHeaderOptions
implements JsonSerializable<RequestHeaderOptions> {
    private OptInHeaderType optInHeaders;
    private OptOutHeaderType optOutHeaders;

    public OptInHeaderType optInHeaders() {
        return this.optInHeaders;
    }

    public RequestHeaderOptions withOptInHeaders(OptInHeaderType optInHeaders) {
        this.optInHeaders = optInHeaders;
        return this;
    }

    public OptOutHeaderType optOutHeaders() {
        return this.optOutHeaders;
    }

    public RequestHeaderOptions withOptOutHeaders(OptOutHeaderType optOutHeaders) {
        this.optOutHeaders = optOutHeaders;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("optInHeaders", this.optInHeaders == null ? null : this.optInHeaders.toString());
        jsonWriter.writeStringField("optOutHeaders", this.optOutHeaders == null ? null : this.optOutHeaders.toString());
        return jsonWriter.writeEndObject();
    }

    public static RequestHeaderOptions fromJson(JsonReader jsonReader) throws IOException {
        return (RequestHeaderOptions)jsonReader.readObject(reader -> {
            RequestHeaderOptions deserializedRequestHeaderOptions = new RequestHeaderOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("optInHeaders".equals(fieldName)) {
                    deserializedRequestHeaderOptions.optInHeaders = OptInHeaderType.fromString(reader.getString());
                    continue;
                }
                if ("optOutHeaders".equals(fieldName)) {
                    deserializedRequestHeaderOptions.optOutHeaders = OptOutHeaderType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRequestHeaderOptions;
        });
    }
}

