/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.LocationQuotaRule;
import com.azure.resourcemanager.providerhub.models.QuotaPolicy;
import java.io.IOException;
import java.util.List;

public final class QuotaRule
implements JsonSerializable<QuotaRule> {
    private QuotaPolicy quotaPolicy;
    private List<LocationQuotaRule> locationRules;
    private List<String> requiredFeatures;

    public QuotaPolicy quotaPolicy() {
        return this.quotaPolicy;
    }

    public QuotaRule withQuotaPolicy(QuotaPolicy quotaPolicy) {
        this.quotaPolicy = quotaPolicy;
        return this;
    }

    public List<LocationQuotaRule> locationRules() {
        return this.locationRules;
    }

    public QuotaRule withLocationRules(List<LocationQuotaRule> locationRules) {
        this.locationRules = locationRules;
        return this;
    }

    public List<String> requiredFeatures() {
        return this.requiredFeatures;
    }

    public QuotaRule withRequiredFeatures(List<String> requiredFeatures) {
        this.requiredFeatures = requiredFeatures;
        return this;
    }

    public void validate() {
        if (this.locationRules() != null) {
            this.locationRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("quotaPolicy", this.quotaPolicy == null ? null : this.quotaPolicy.toString());
        jsonWriter.writeArrayField("locationRules", this.locationRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("requiredFeatures", this.requiredFeatures, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static QuotaRule fromJson(JsonReader jsonReader) throws IOException {
        return (QuotaRule)jsonReader.readObject(reader -> {
            QuotaRule deserializedQuotaRule = new QuotaRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("quotaPolicy".equals(fieldName)) {
                    deserializedQuotaRule.quotaPolicy = QuotaPolicy.fromString(reader.getString());
                    continue;
                }
                if ("locationRules".equals(fieldName)) {
                    List locationRules;
                    deserializedQuotaRule.locationRules = locationRules = reader.readArray(reader1 -> LocationQuotaRule.fromJson(reader1));
                    continue;
                }
                if ("requiredFeatures".equals(fieldName)) {
                    List requiredFeatures;
                    deserializedQuotaRule.requiredFeatures = requiredFeatures = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQuotaRule;
        });
    }
}

