/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.SubscriptionLifecycleNotificationSpecifications;
import com.azure.resourcemanager.providerhub.models.SubscriptionStateOverrideAction;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications
extends SubscriptionLifecycleNotificationSpecifications {
    @Override
    public ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications withSubscriptionStateOverrideActions(List<SubscriptionStateOverrideAction> subscriptionStateOverrideActions) {
        super.withSubscriptionStateOverrideActions(subscriptionStateOverrideActions);
        return this;
    }

    @Override
    public ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications withSoftDeleteTtl(Duration softDeleteTtl) {
        super.withSoftDeleteTtl(softDeleteTtl);
        return this;
    }

    @Override
    public void validate() {
        if (this.subscriptionStateOverrideActions() != null) {
            this.subscriptionStateOverrideActions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("subscriptionStateOverrideActions", this.subscriptionStateOverrideActions(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("softDeleteTTL", CoreUtils.durationToStringWithDays((Duration)this.softDeleteTtl()));
        return jsonWriter.writeEndObject();
    }

    public static ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications fromJson(JsonReader jsonReader) throws IOException {
        return (ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications)jsonReader.readObject(reader -> {
            ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications deserializedProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications = new ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subscriptionStateOverrideActions".equals(fieldName)) {
                    List subscriptionStateOverrideActions = reader.readArray(reader1 -> SubscriptionStateOverrideAction.fromJson(reader1));
                    deserializedProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications.withSubscriptionStateOverrideActions(subscriptionStateOverrideActions);
                    continue;
                }
                if ("softDeleteTTL".equals(fieldName)) {
                    deserializedProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications.withSoftDeleteTtl((Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString())));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications;
        });
    }
}

