/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ProviderHubMetadata;
import com.azure.resourcemanager.providerhub.models.ProviderHubMetadataProviderAuthentication;
import com.azure.resourcemanager.providerhub.models.ProviderHubMetadataThirdPartyProviderAuthorization;
import com.azure.resourcemanager.providerhub.models.ResourceProviderAuthorization;
import java.io.IOException;
import java.util.List;

public final class ProviderRegistrationPropertiesProviderHubMetadata
extends ProviderHubMetadata {
    @Override
    public ProviderRegistrationPropertiesProviderHubMetadata withProviderAuthorizations(List<ResourceProviderAuthorization> providerAuthorizations) {
        super.withProviderAuthorizations(providerAuthorizations);
        return this;
    }

    @Override
    public ProviderRegistrationPropertiesProviderHubMetadata withProviderAuthentication(ProviderHubMetadataProviderAuthentication providerAuthentication) {
        super.withProviderAuthentication(providerAuthentication);
        return this;
    }

    @Override
    public ProviderRegistrationPropertiesProviderHubMetadata withThirdPartyProviderAuthorization(ProviderHubMetadataThirdPartyProviderAuthorization thirdPartyProviderAuthorization) {
        super.withThirdPartyProviderAuthorization(thirdPartyProviderAuthorization);
        return this;
    }

    @Override
    public ProviderRegistrationPropertiesProviderHubMetadata withDirectRpRoleDefinitionId(String directRpRoleDefinitionId) {
        super.withDirectRpRoleDefinitionId(directRpRoleDefinitionId);
        return this;
    }

    @Override
    public ProviderRegistrationPropertiesProviderHubMetadata withRegionalAsyncOperationResourceTypeName(String regionalAsyncOperationResourceTypeName) {
        super.withRegionalAsyncOperationResourceTypeName(regionalAsyncOperationResourceTypeName);
        return this;
    }

    @Override
    public ProviderRegistrationPropertiesProviderHubMetadata withGlobalAsyncOperationResourceTypeName(String globalAsyncOperationResourceTypeName) {
        super.withGlobalAsyncOperationResourceTypeName(globalAsyncOperationResourceTypeName);
        return this;
    }

    @Override
    public void validate() {
        if (this.providerAuthorizations() != null) {
            this.providerAuthorizations().forEach(e -> e.validate());
        }
        if (this.providerAuthentication() != null) {
            this.providerAuthentication().validate();
        }
        if (this.thirdPartyProviderAuthorization() != null) {
            this.thirdPartyProviderAuthorization().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("providerAuthorizations", this.providerAuthorizations(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("providerAuthentication", (JsonSerializable)this.providerAuthentication());
        jsonWriter.writeJsonField("thirdPartyProviderAuthorization", (JsonSerializable)this.thirdPartyProviderAuthorization());
        jsonWriter.writeStringField("directRpRoleDefinitionId", this.directRpRoleDefinitionId());
        jsonWriter.writeStringField("regionalAsyncOperationResourceTypeName", this.regionalAsyncOperationResourceTypeName());
        jsonWriter.writeStringField("globalAsyncOperationResourceTypeName", this.globalAsyncOperationResourceTypeName());
        return jsonWriter.writeEndObject();
    }

    public static ProviderRegistrationPropertiesProviderHubMetadata fromJson(JsonReader jsonReader) throws IOException {
        return (ProviderRegistrationPropertiesProviderHubMetadata)jsonReader.readObject(reader -> {
            ProviderRegistrationPropertiesProviderHubMetadata deserializedProviderRegistrationPropertiesProviderHubMetadata = new ProviderRegistrationPropertiesProviderHubMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("providerAuthorizations".equals(fieldName)) {
                    List providerAuthorizations = reader.readArray(reader1 -> ResourceProviderAuthorization.fromJson(reader1));
                    deserializedProviderRegistrationPropertiesProviderHubMetadata.withProviderAuthorizations(providerAuthorizations);
                    continue;
                }
                if ("providerAuthentication".equals(fieldName)) {
                    deserializedProviderRegistrationPropertiesProviderHubMetadata.withProviderAuthentication(ProviderHubMetadataProviderAuthentication.fromJson(reader));
                    continue;
                }
                if ("thirdPartyProviderAuthorization".equals(fieldName)) {
                    deserializedProviderRegistrationPropertiesProviderHubMetadata.withThirdPartyProviderAuthorization(ProviderHubMetadataThirdPartyProviderAuthorization.fromJson(reader));
                    continue;
                }
                if ("directRpRoleDefinitionId".equals(fieldName)) {
                    deserializedProviderRegistrationPropertiesProviderHubMetadata.withDirectRpRoleDefinitionId(reader.getString());
                    continue;
                }
                if ("regionalAsyncOperationResourceTypeName".equals(fieldName)) {
                    deserializedProviderRegistrationPropertiesProviderHubMetadata.withRegionalAsyncOperationResourceTypeName(reader.getString());
                    continue;
                }
                if ("globalAsyncOperationResourceTypeName".equals(fieldName)) {
                    deserializedProviderRegistrationPropertiesProviderHubMetadata.withGlobalAsyncOperationResourceTypeName(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProviderRegistrationPropertiesProviderHubMetadata;
        });
    }
}

