/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.CrossTenantTokenValidation;
import com.azure.resourcemanager.providerhub.models.FanoutLinkedNotificationRule;
import com.azure.resourcemanager.providerhub.models.Notification;
import com.azure.resourcemanager.providerhub.models.NotificationOptions;
import com.azure.resourcemanager.providerhub.models.ProviderRegistrationPropertiesPrivateResourceProviderConfiguration;
import com.azure.resourcemanager.providerhub.models.ProviderRegistrationPropertiesProviderHubMetadata;
import com.azure.resourcemanager.providerhub.models.ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications;
import com.azure.resourcemanager.providerhub.models.ProvisioningState;
import com.azure.resourcemanager.providerhub.models.ResourceHydrationAccount;
import com.azure.resourcemanager.providerhub.models.ResourceProviderAuthorization;
import com.azure.resourcemanager.providerhub.models.ResourceProviderAuthorizationRules;
import com.azure.resourcemanager.providerhub.models.ResourceProviderCapabilities;
import com.azure.resourcemanager.providerhub.models.ResourceProviderEndpoint;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestProperties;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesDstsConfiguration;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesFeaturesRule;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesManagement;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesNotificationSettings;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesProviderAuthentication;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesRequestHeaderOptions;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesResourceGroupLockOptionDuringMove;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesResponseOptions;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestPropertiesTemplateDeploymentOptions;
import com.azure.resourcemanager.providerhub.models.ResourceProviderService;
import com.azure.resourcemanager.providerhub.models.ResourceProviderType;
import com.azure.resourcemanager.providerhub.models.TokenAuthConfiguration;
import java.io.IOException;
import java.util.List;

public final class ProviderRegistrationProperties
extends ResourceProviderManifestProperties {
    private ProviderRegistrationPropertiesProviderHubMetadata providerHubMetadata;
    private ProvisioningState provisioningState;
    private ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications subscriptionLifecycleNotificationSpecifications;
    private ProviderRegistrationPropertiesPrivateResourceProviderConfiguration privateResourceProviderConfiguration;
    private TokenAuthConfiguration tokenAuthConfiguration;

    public ProviderRegistrationPropertiesProviderHubMetadata providerHubMetadata() {
        return this.providerHubMetadata;
    }

    public ProviderRegistrationProperties withProviderHubMetadata(ProviderRegistrationPropertiesProviderHubMetadata providerHubMetadata) {
        this.providerHubMetadata = providerHubMetadata;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications subscriptionLifecycleNotificationSpecifications() {
        return this.subscriptionLifecycleNotificationSpecifications;
    }

    public ProviderRegistrationProperties withSubscriptionLifecycleNotificationSpecifications(ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications subscriptionLifecycleNotificationSpecifications) {
        this.subscriptionLifecycleNotificationSpecifications = subscriptionLifecycleNotificationSpecifications;
        return this;
    }

    public ProviderRegistrationPropertiesPrivateResourceProviderConfiguration privateResourceProviderConfiguration() {
        return this.privateResourceProviderConfiguration;
    }

    public ProviderRegistrationProperties withPrivateResourceProviderConfiguration(ProviderRegistrationPropertiesPrivateResourceProviderConfiguration privateResourceProviderConfiguration) {
        this.privateResourceProviderConfiguration = privateResourceProviderConfiguration;
        return this;
    }

    public TokenAuthConfiguration tokenAuthConfiguration() {
        return this.tokenAuthConfiguration;
    }

    public ProviderRegistrationProperties withTokenAuthConfiguration(TokenAuthConfiguration tokenAuthConfiguration) {
        this.tokenAuthConfiguration = tokenAuthConfiguration;
        return this;
    }

    @Override
    public ProviderRegistrationProperties withProviderAuthentication(ResourceProviderManifestPropertiesProviderAuthentication providerAuthentication) {
        super.withProviderAuthentication(providerAuthentication);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withProviderAuthorizations(List<ResourceProviderAuthorization> providerAuthorizations) {
        super.withProviderAuthorizations(providerAuthorizations);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withNamespace(String namespace) {
        super.withNamespace(namespace);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withServices(List<ResourceProviderService> services) {
        super.withServices(services);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withServiceName(String serviceName) {
        super.withServiceName(serviceName);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withProviderVersion(String providerVersion) {
        super.withProviderVersion(providerVersion);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withProviderType(ResourceProviderType providerType) {
        super.withProviderType(providerType);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withRequiredFeatures(List<String> requiredFeatures) {
        super.withRequiredFeatures(requiredFeatures);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withFeaturesRule(ResourceProviderManifestPropertiesFeaturesRule featuresRule) {
        super.withFeaturesRule(featuresRule);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withRequestHeaderOptions(ResourceProviderManifestPropertiesRequestHeaderOptions requestHeaderOptions) {
        super.withRequestHeaderOptions(requestHeaderOptions);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withManagement(ResourceProviderManifestPropertiesManagement management) {
        super.withManagement(management);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withCapabilities(List<ResourceProviderCapabilities> capabilities) {
        super.withCapabilities(capabilities);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withCrossTenantTokenValidation(CrossTenantTokenValidation crossTenantTokenValidation) {
        super.withCrossTenantTokenValidation(crossTenantTokenValidation);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withMetadata(Object metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withTemplateDeploymentOptions(ResourceProviderManifestPropertiesTemplateDeploymentOptions templateDeploymentOptions) {
        super.withTemplateDeploymentOptions(templateDeploymentOptions);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withGlobalNotificationEndpoints(List<ResourceProviderEndpoint> globalNotificationEndpoints) {
        super.withGlobalNotificationEndpoints(globalNotificationEndpoints);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withEnableTenantLinkedNotification(Boolean enableTenantLinkedNotification) {
        super.withEnableTenantLinkedNotification(enableTenantLinkedNotification);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withNotifications(List<Notification> notifications) {
        super.withNotifications(notifications);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withLinkedNotificationRules(List<FanoutLinkedNotificationRule> linkedNotificationRules) {
        super.withLinkedNotificationRules(linkedNotificationRules);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withResourceProviderAuthorizationRules(ResourceProviderAuthorizationRules resourceProviderAuthorizationRules) {
        super.withResourceProviderAuthorizationRules(resourceProviderAuthorizationRules);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withDstsConfiguration(ResourceProviderManifestPropertiesDstsConfiguration dstsConfiguration) {
        super.withDstsConfiguration(dstsConfiguration);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withNotificationOptions(NotificationOptions notificationOptions) {
        super.withNotificationOptions(notificationOptions);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withResourceHydrationAccounts(List<ResourceHydrationAccount> resourceHydrationAccounts) {
        super.withResourceHydrationAccounts(resourceHydrationAccounts);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withNotificationSettings(ResourceProviderManifestPropertiesNotificationSettings notificationSettings) {
        super.withNotificationSettings(notificationSettings);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withManagementGroupGlobalNotificationEndpoints(List<ResourceProviderEndpoint> managementGroupGlobalNotificationEndpoints) {
        super.withManagementGroupGlobalNotificationEndpoints(managementGroupGlobalNotificationEndpoints);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withOptionalFeatures(List<String> optionalFeatures) {
        super.withOptionalFeatures(optionalFeatures);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withResourceGroupLockOptionDuringMove(ResourceProviderManifestPropertiesResourceGroupLockOptionDuringMove resourceGroupLockOptionDuringMove) {
        super.withResourceGroupLockOptionDuringMove(resourceGroupLockOptionDuringMove);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withResponseOptions(ResourceProviderManifestPropertiesResponseOptions responseOptions) {
        super.withResponseOptions(responseOptions);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withLegacyNamespace(String legacyNamespace) {
        super.withLegacyNamespace(legacyNamespace);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withLegacyRegistrations(List<String> legacyRegistrations) {
        super.withLegacyRegistrations(legacyRegistrations);
        return this;
    }

    @Override
    public ProviderRegistrationProperties withCustomManifestVersion(String customManifestVersion) {
        super.withCustomManifestVersion(customManifestVersion);
        return this;
    }

    @Override
    public void validate() {
        if (this.providerHubMetadata() != null) {
            this.providerHubMetadata().validate();
        }
        if (this.subscriptionLifecycleNotificationSpecifications() != null) {
            this.subscriptionLifecycleNotificationSpecifications().validate();
        }
        if (this.privateResourceProviderConfiguration() != null) {
            this.privateResourceProviderConfiguration().validate();
        }
        if (this.tokenAuthConfiguration() != null) {
            this.tokenAuthConfiguration().validate();
        }
        if (this.providerAuthentication() != null) {
            this.providerAuthentication().validate();
        }
        if (this.providerAuthorizations() != null) {
            this.providerAuthorizations().forEach(e -> e.validate());
        }
        if (this.services() != null) {
            this.services().forEach(e -> e.validate());
        }
        if (this.featuresRule() != null) {
            this.featuresRule().validate();
        }
        if (this.requestHeaderOptions() != null) {
            this.requestHeaderOptions().validate();
        }
        if (this.management() != null) {
            this.management().validate();
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
        if (this.templateDeploymentOptions() != null) {
            this.templateDeploymentOptions().validate();
        }
        if (this.globalNotificationEndpoints() != null) {
            this.globalNotificationEndpoints().forEach(e -> e.validate());
        }
        if (this.notifications() != null) {
            this.notifications().forEach(e -> e.validate());
        }
        if (this.linkedNotificationRules() != null) {
            this.linkedNotificationRules().forEach(e -> e.validate());
        }
        if (this.resourceProviderAuthorizationRules() != null) {
            this.resourceProviderAuthorizationRules().validate();
        }
        if (this.dstsConfiguration() != null) {
            this.dstsConfiguration().validate();
        }
        if (this.resourceHydrationAccounts() != null) {
            this.resourceHydrationAccounts().forEach(e -> e.validate());
        }
        if (this.notificationSettings() != null) {
            this.notificationSettings().validate();
        }
        if (this.managementGroupGlobalNotificationEndpoints() != null) {
            this.managementGroupGlobalNotificationEndpoints().forEach(e -> e.validate());
        }
        if (this.resourceGroupLockOptionDuringMove() != null) {
            this.resourceGroupLockOptionDuringMove().validate();
        }
        if (this.responseOptions() != null) {
            this.responseOptions().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("providerAuthentication", (JsonSerializable)this.providerAuthentication());
        jsonWriter.writeArrayField("providerAuthorizations", this.providerAuthorizations(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("namespace", this.namespace());
        jsonWriter.writeArrayField("services", this.services(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("serviceName", this.serviceName());
        jsonWriter.writeStringField("providerVersion", this.providerVersion());
        jsonWriter.writeStringField("providerType", this.providerType() == null ? null : this.providerType().toString());
        jsonWriter.writeArrayField("requiredFeatures", this.requiredFeatures(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("featuresRule", (JsonSerializable)this.featuresRule());
        jsonWriter.writeJsonField("requestHeaderOptions", (JsonSerializable)this.requestHeaderOptions());
        jsonWriter.writeJsonField("management", (JsonSerializable)this.management());
        jsonWriter.writeArrayField("capabilities", this.capabilities(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("crossTenantTokenValidation", this.crossTenantTokenValidation() == null ? null : this.crossTenantTokenValidation().toString());
        if (this.metadata() != null) {
            jsonWriter.writeUntypedField("metadata", this.metadata());
        }
        jsonWriter.writeJsonField("templateDeploymentOptions", (JsonSerializable)this.templateDeploymentOptions());
        jsonWriter.writeArrayField("globalNotificationEndpoints", this.globalNotificationEndpoints(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("enableTenantLinkedNotification", this.enableTenantLinkedNotification());
        jsonWriter.writeArrayField("notifications", this.notifications(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("linkedNotificationRules", this.linkedNotificationRules(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("resourceProviderAuthorizationRules", (JsonSerializable)this.resourceProviderAuthorizationRules());
        jsonWriter.writeJsonField("dstsConfiguration", (JsonSerializable)this.dstsConfiguration());
        jsonWriter.writeStringField("notificationOptions", this.notificationOptions() == null ? null : this.notificationOptions().toString());
        jsonWriter.writeArrayField("resourceHydrationAccounts", this.resourceHydrationAccounts(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("notificationSettings", (JsonSerializable)this.notificationSettings());
        jsonWriter.writeArrayField("managementGroupGlobalNotificationEndpoints", this.managementGroupGlobalNotificationEndpoints(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("optionalFeatures", this.optionalFeatures(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("resourceGroupLockOptionDuringMove", (JsonSerializable)this.resourceGroupLockOptionDuringMove());
        jsonWriter.writeJsonField("responseOptions", (JsonSerializable)this.responseOptions());
        jsonWriter.writeStringField("legacyNamespace", this.legacyNamespace());
        jsonWriter.writeArrayField("legacyRegistrations", this.legacyRegistrations(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("customManifestVersion", this.customManifestVersion());
        jsonWriter.writeJsonField("providerHubMetadata", (JsonSerializable)this.providerHubMetadata);
        jsonWriter.writeJsonField("subscriptionLifecycleNotificationSpecifications", (JsonSerializable)this.subscriptionLifecycleNotificationSpecifications);
        jsonWriter.writeJsonField("privateResourceProviderConfiguration", (JsonSerializable)this.privateResourceProviderConfiguration);
        jsonWriter.writeJsonField("tokenAuthConfiguration", (JsonSerializable)this.tokenAuthConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static ProviderRegistrationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ProviderRegistrationProperties)jsonReader.readObject(reader -> {
            ProviderRegistrationProperties deserializedProviderRegistrationProperties = new ProviderRegistrationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("providerAuthentication".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withProviderAuthentication(ResourceProviderManifestPropertiesProviderAuthentication.fromJson(reader));
                    continue;
                }
                if ("providerAuthorizations".equals(fieldName)) {
                    List providerAuthorizations = reader.readArray(reader1 -> ResourceProviderAuthorization.fromJson(reader1));
                    deserializedProviderRegistrationProperties.withProviderAuthorizations(providerAuthorizations);
                    continue;
                }
                if ("namespace".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withNamespace(reader.getString());
                    continue;
                }
                if ("services".equals(fieldName)) {
                    List services = reader.readArray(reader1 -> ResourceProviderService.fromJson(reader1));
                    deserializedProviderRegistrationProperties.withServices(services);
                    continue;
                }
                if ("serviceName".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withServiceName(reader.getString());
                    continue;
                }
                if ("providerVersion".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withProviderVersion(reader.getString());
                    continue;
                }
                if ("providerType".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withProviderType(ResourceProviderType.fromString(reader.getString()));
                    continue;
                }
                if ("requiredFeatures".equals(fieldName)) {
                    List requiredFeatures = reader.readArray(reader1 -> reader1.getString());
                    deserializedProviderRegistrationProperties.withRequiredFeatures(requiredFeatures);
                    continue;
                }
                if ("featuresRule".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withFeaturesRule(ResourceProviderManifestPropertiesFeaturesRule.fromJson(reader));
                    continue;
                }
                if ("requestHeaderOptions".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withRequestHeaderOptions(ResourceProviderManifestPropertiesRequestHeaderOptions.fromJson(reader));
                    continue;
                }
                if ("management".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withManagement(ResourceProviderManifestPropertiesManagement.fromJson(reader));
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities = reader.readArray(reader1 -> ResourceProviderCapabilities.fromJson(reader1));
                    deserializedProviderRegistrationProperties.withCapabilities(capabilities);
                    continue;
                }
                if ("crossTenantTokenValidation".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withCrossTenantTokenValidation(CrossTenantTokenValidation.fromString(reader.getString()));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withMetadata(reader.readUntyped());
                    continue;
                }
                if ("templateDeploymentOptions".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withTemplateDeploymentOptions(ResourceProviderManifestPropertiesTemplateDeploymentOptions.fromJson(reader));
                    continue;
                }
                if ("globalNotificationEndpoints".equals(fieldName)) {
                    List globalNotificationEndpoints = reader.readArray(reader1 -> ResourceProviderEndpoint.fromJson(reader1));
                    deserializedProviderRegistrationProperties.withGlobalNotificationEndpoints(globalNotificationEndpoints);
                    continue;
                }
                if ("enableTenantLinkedNotification".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withEnableTenantLinkedNotification((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("notifications".equals(fieldName)) {
                    List notifications = reader.readArray(reader1 -> Notification.fromJson(reader1));
                    deserializedProviderRegistrationProperties.withNotifications(notifications);
                    continue;
                }
                if ("linkedNotificationRules".equals(fieldName)) {
                    List linkedNotificationRules = reader.readArray(reader1 -> FanoutLinkedNotificationRule.fromJson(reader1));
                    deserializedProviderRegistrationProperties.withLinkedNotificationRules(linkedNotificationRules);
                    continue;
                }
                if ("resourceProviderAuthorizationRules".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withResourceProviderAuthorizationRules(ResourceProviderAuthorizationRules.fromJson(reader));
                    continue;
                }
                if ("dstsConfiguration".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withDstsConfiguration(ResourceProviderManifestPropertiesDstsConfiguration.fromJson(reader));
                    continue;
                }
                if ("notificationOptions".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withNotificationOptions(NotificationOptions.fromString(reader.getString()));
                    continue;
                }
                if ("resourceHydrationAccounts".equals(fieldName)) {
                    List resourceHydrationAccounts = reader.readArray(reader1 -> ResourceHydrationAccount.fromJson(reader1));
                    deserializedProviderRegistrationProperties.withResourceHydrationAccounts(resourceHydrationAccounts);
                    continue;
                }
                if ("notificationSettings".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withNotificationSettings(ResourceProviderManifestPropertiesNotificationSettings.fromJson(reader));
                    continue;
                }
                if ("managementGroupGlobalNotificationEndpoints".equals(fieldName)) {
                    List managementGroupGlobalNotificationEndpoints = reader.readArray(reader1 -> ResourceProviderEndpoint.fromJson(reader1));
                    deserializedProviderRegistrationProperties.withManagementGroupGlobalNotificationEndpoints(managementGroupGlobalNotificationEndpoints);
                    continue;
                }
                if ("optionalFeatures".equals(fieldName)) {
                    List optionalFeatures = reader.readArray(reader1 -> reader1.getString());
                    deserializedProviderRegistrationProperties.withOptionalFeatures(optionalFeatures);
                    continue;
                }
                if ("resourceGroupLockOptionDuringMove".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withResourceGroupLockOptionDuringMove(ResourceProviderManifestPropertiesResourceGroupLockOptionDuringMove.fromJson(reader));
                    continue;
                }
                if ("responseOptions".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withResponseOptions(ResourceProviderManifestPropertiesResponseOptions.fromJson(reader));
                    continue;
                }
                if ("legacyNamespace".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withLegacyNamespace(reader.getString());
                    continue;
                }
                if ("legacyRegistrations".equals(fieldName)) {
                    List legacyRegistrations = reader.readArray(reader1 -> reader1.getString());
                    deserializedProviderRegistrationProperties.withLegacyRegistrations(legacyRegistrations);
                    continue;
                }
                if ("customManifestVersion".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.withCustomManifestVersion(reader.getString());
                    continue;
                }
                if ("providerHubMetadata".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.providerHubMetadata = ProviderRegistrationPropertiesProviderHubMetadata.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("subscriptionLifecycleNotificationSpecifications".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.subscriptionLifecycleNotificationSpecifications = ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications.fromJson(reader);
                    continue;
                }
                if ("privateResourceProviderConfiguration".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.privateResourceProviderConfiguration = ProviderRegistrationPropertiesPrivateResourceProviderConfiguration.fromJson(reader);
                    continue;
                }
                if ("tokenAuthConfiguration".equals(fieldName)) {
                    deserializedProviderRegistrationProperties.tokenAuthConfiguration = TokenAuthConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProviderRegistrationProperties;
        });
    }
}

