/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.LightHouseAuthorization;
import com.azure.resourcemanager.providerhub.models.ThirdPartyProviderAuthorization;
import java.io.IOException;
import java.util.List;

public final class ProviderHubMetadataThirdPartyProviderAuthorization
extends ThirdPartyProviderAuthorization {
    @Override
    public ProviderHubMetadataThirdPartyProviderAuthorization withAuthorizations(List<LightHouseAuthorization> authorizations) {
        super.withAuthorizations(authorizations);
        return this;
    }

    @Override
    public ProviderHubMetadataThirdPartyProviderAuthorization withManagedByTenantId(String managedByTenantId) {
        super.withManagedByTenantId(managedByTenantId);
        return this;
    }

    @Override
    public void validate() {
        if (this.authorizations() != null) {
            this.authorizations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("authorizations", this.authorizations(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("managedByTenantId", this.managedByTenantId());
        return jsonWriter.writeEndObject();
    }

    public static ProviderHubMetadataThirdPartyProviderAuthorization fromJson(JsonReader jsonReader) throws IOException {
        return (ProviderHubMetadataThirdPartyProviderAuthorization)jsonReader.readObject(reader -> {
            ProviderHubMetadataThirdPartyProviderAuthorization deserializedProviderHubMetadataThirdPartyProviderAuthorization = new ProviderHubMetadataThirdPartyProviderAuthorization();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("authorizations".equals(fieldName)) {
                    List authorizations = reader.readArray(reader1 -> LightHouseAuthorization.fromJson(reader1));
                    deserializedProviderHubMetadataThirdPartyProviderAuthorization.withAuthorizations(authorizations);
                    continue;
                }
                if ("managedByTenantId".equals(fieldName)) {
                    deserializedProviderHubMetadataThirdPartyProviderAuthorization.withManagedByTenantId(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProviderHubMetadataThirdPartyProviderAuthorization;
        });
    }
}

