/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ProviderHubMetadataProviderAuthentication;
import com.azure.resourcemanager.providerhub.models.ProviderHubMetadataThirdPartyProviderAuthorization;
import com.azure.resourcemanager.providerhub.models.ResourceProviderAuthorization;
import java.io.IOException;
import java.util.List;

public class ProviderHubMetadata
implements JsonSerializable<ProviderHubMetadata> {
    private List<ResourceProviderAuthorization> providerAuthorizations;
    private ProviderHubMetadataProviderAuthentication providerAuthentication;
    private ProviderHubMetadataThirdPartyProviderAuthorization thirdPartyProviderAuthorization;
    private String directRpRoleDefinitionId;
    private String regionalAsyncOperationResourceTypeName;
    private String globalAsyncOperationResourceTypeName;

    public List<ResourceProviderAuthorization> providerAuthorizations() {
        return this.providerAuthorizations;
    }

    public ProviderHubMetadata withProviderAuthorizations(List<ResourceProviderAuthorization> providerAuthorizations) {
        this.providerAuthorizations = providerAuthorizations;
        return this;
    }

    public ProviderHubMetadataProviderAuthentication providerAuthentication() {
        return this.providerAuthentication;
    }

    public ProviderHubMetadata withProviderAuthentication(ProviderHubMetadataProviderAuthentication providerAuthentication) {
        this.providerAuthentication = providerAuthentication;
        return this;
    }

    public ProviderHubMetadataThirdPartyProviderAuthorization thirdPartyProviderAuthorization() {
        return this.thirdPartyProviderAuthorization;
    }

    public ProviderHubMetadata withThirdPartyProviderAuthorization(ProviderHubMetadataThirdPartyProviderAuthorization thirdPartyProviderAuthorization) {
        this.thirdPartyProviderAuthorization = thirdPartyProviderAuthorization;
        return this;
    }

    public String directRpRoleDefinitionId() {
        return this.directRpRoleDefinitionId;
    }

    public ProviderHubMetadata withDirectRpRoleDefinitionId(String directRpRoleDefinitionId) {
        this.directRpRoleDefinitionId = directRpRoleDefinitionId;
        return this;
    }

    public String regionalAsyncOperationResourceTypeName() {
        return this.regionalAsyncOperationResourceTypeName;
    }

    public ProviderHubMetadata withRegionalAsyncOperationResourceTypeName(String regionalAsyncOperationResourceTypeName) {
        this.regionalAsyncOperationResourceTypeName = regionalAsyncOperationResourceTypeName;
        return this;
    }

    public String globalAsyncOperationResourceTypeName() {
        return this.globalAsyncOperationResourceTypeName;
    }

    public ProviderHubMetadata withGlobalAsyncOperationResourceTypeName(String globalAsyncOperationResourceTypeName) {
        this.globalAsyncOperationResourceTypeName = globalAsyncOperationResourceTypeName;
        return this;
    }

    public void validate() {
        if (this.providerAuthorizations() != null) {
            this.providerAuthorizations().forEach(e -> e.validate());
        }
        if (this.providerAuthentication() != null) {
            this.providerAuthentication().validate();
        }
        if (this.thirdPartyProviderAuthorization() != null) {
            this.thirdPartyProviderAuthorization().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("providerAuthorizations", this.providerAuthorizations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("providerAuthentication", (JsonSerializable)this.providerAuthentication);
        jsonWriter.writeJsonField("thirdPartyProviderAuthorization", (JsonSerializable)this.thirdPartyProviderAuthorization);
        jsonWriter.writeStringField("directRpRoleDefinitionId", this.directRpRoleDefinitionId);
        jsonWriter.writeStringField("regionalAsyncOperationResourceTypeName", this.regionalAsyncOperationResourceTypeName);
        jsonWriter.writeStringField("globalAsyncOperationResourceTypeName", this.globalAsyncOperationResourceTypeName);
        return jsonWriter.writeEndObject();
    }

    public static ProviderHubMetadata fromJson(JsonReader jsonReader) throws IOException {
        return (ProviderHubMetadata)jsonReader.readObject(reader -> {
            ProviderHubMetadata deserializedProviderHubMetadata = new ProviderHubMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("providerAuthorizations".equals(fieldName)) {
                    List providerAuthorizations;
                    deserializedProviderHubMetadata.providerAuthorizations = providerAuthorizations = reader.readArray(reader1 -> ResourceProviderAuthorization.fromJson(reader1));
                    continue;
                }
                if ("providerAuthentication".equals(fieldName)) {
                    deserializedProviderHubMetadata.providerAuthentication = ProviderHubMetadataProviderAuthentication.fromJson(reader);
                    continue;
                }
                if ("thirdPartyProviderAuthorization".equals(fieldName)) {
                    deserializedProviderHubMetadata.thirdPartyProviderAuthorization = ProviderHubMetadataThirdPartyProviderAuthorization.fromJson(reader);
                    continue;
                }
                if ("directRpRoleDefinitionId".equals(fieldName)) {
                    deserializedProviderHubMetadata.directRpRoleDefinitionId = reader.getString();
                    continue;
                }
                if ("regionalAsyncOperationResourceTypeName".equals(fieldName)) {
                    deserializedProviderHubMetadata.regionalAsyncOperationResourceTypeName = reader.getString();
                    continue;
                }
                if ("globalAsyncOperationResourceTypeName".equals(fieldName)) {
                    deserializedProviderHubMetadata.globalAsyncOperationResourceTypeName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProviderHubMetadata;
        });
    }
}

