/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.LocalizedOperationDefinition;
import com.azure.resourcemanager.providerhub.models.OperationsContentProperties;
import java.io.IOException;
import java.util.List;

public final class OperationsPutContentProperties
extends OperationsContentProperties {
    @Override
    public OperationsPutContentProperties withContents(List<LocalizedOperationDefinition> contents) {
        super.withContents(contents);
        return this;
    }

    @Override
    public void validate() {
        if (this.contents() != null) {
            this.contents().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("contents", this.contents(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static OperationsPutContentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OperationsPutContentProperties)jsonReader.readObject(reader -> {
            OperationsPutContentProperties deserializedOperationsPutContentProperties = new OperationsPutContentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contents".equals(fieldName)) {
                    List contents = reader.readArray(reader1 -> LocalizedOperationDefinition.fromJson(reader1));
                    deserializedOperationsPutContentProperties.withContents(contents);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationsPutContentProperties;
        });
    }
}

