/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class OperationsDisplayDefinition
implements JsonSerializable<OperationsDisplayDefinition> {
    private String provider;
    private String resource;
    private String operation;
    private String description;
    private static final ClientLogger LOGGER = new ClientLogger(OperationsDisplayDefinition.class);

    public String provider() {
        return this.provider;
    }

    public OperationsDisplayDefinition withProvider(String provider) {
        this.provider = provider;
        return this;
    }

    public String resource() {
        return this.resource;
    }

    public OperationsDisplayDefinition withResource(String resource) {
        this.resource = resource;
        return this;
    }

    public String operation() {
        return this.operation;
    }

    public OperationsDisplayDefinition withOperation(String operation) {
        this.operation = operation;
        return this;
    }

    public String description() {
        return this.description;
    }

    public OperationsDisplayDefinition withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.provider() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property provider in model OperationsDisplayDefinition"));
        }
        if (this.resource() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resource in model OperationsDisplayDefinition"));
        }
        if (this.operation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operation in model OperationsDisplayDefinition"));
        }
        if (this.description() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property description in model OperationsDisplayDefinition"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provider", this.provider);
        jsonWriter.writeStringField("resource", this.resource);
        jsonWriter.writeStringField("operation", this.operation);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static OperationsDisplayDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (OperationsDisplayDefinition)jsonReader.readObject(reader -> {
            OperationsDisplayDefinition deserializedOperationsDisplayDefinition = new OperationsDisplayDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provider".equals(fieldName)) {
                    deserializedOperationsDisplayDefinition.provider = reader.getString();
                    continue;
                }
                if ("resource".equals(fieldName)) {
                    deserializedOperationsDisplayDefinition.resource = reader.getString();
                    continue;
                }
                if ("operation".equals(fieldName)) {
                    deserializedOperationsDisplayDefinition.operation = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedOperationsDisplayDefinition.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationsDisplayDefinition;
        });
    }
}

