/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.MessageScope;
import com.azure.resourcemanager.providerhub.models.NotificationEndpoint;
import com.azure.resourcemanager.providerhub.models.NotificationMode;
import com.azure.resourcemanager.providerhub.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class NotificationRegistrationProperties
implements JsonSerializable<NotificationRegistrationProperties> {
    private NotificationMode notificationMode;
    private MessageScope messageScope;
    private List<String> includedEvents;
    private List<NotificationEndpoint> notificationEndpoints;
    private ProvisioningState provisioningState;

    public NotificationMode notificationMode() {
        return this.notificationMode;
    }

    public NotificationRegistrationProperties withNotificationMode(NotificationMode notificationMode) {
        this.notificationMode = notificationMode;
        return this;
    }

    public MessageScope messageScope() {
        return this.messageScope;
    }

    public NotificationRegistrationProperties withMessageScope(MessageScope messageScope) {
        this.messageScope = messageScope;
        return this;
    }

    public List<String> includedEvents() {
        return this.includedEvents;
    }

    public NotificationRegistrationProperties withIncludedEvents(List<String> includedEvents) {
        this.includedEvents = includedEvents;
        return this;
    }

    public List<NotificationEndpoint> notificationEndpoints() {
        return this.notificationEndpoints;
    }

    public NotificationRegistrationProperties withNotificationEndpoints(List<NotificationEndpoint> notificationEndpoints) {
        this.notificationEndpoints = notificationEndpoints;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.notificationEndpoints() != null) {
            this.notificationEndpoints().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("notificationMode", this.notificationMode == null ? null : this.notificationMode.toString());
        jsonWriter.writeStringField("messageScope", this.messageScope == null ? null : this.messageScope.toString());
        jsonWriter.writeArrayField("includedEvents", this.includedEvents, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("notificationEndpoints", this.notificationEndpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static NotificationRegistrationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NotificationRegistrationProperties)jsonReader.readObject(reader -> {
            NotificationRegistrationProperties deserializedNotificationRegistrationProperties = new NotificationRegistrationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("notificationMode".equals(fieldName)) {
                    deserializedNotificationRegistrationProperties.notificationMode = NotificationMode.fromString(reader.getString());
                    continue;
                }
                if ("messageScope".equals(fieldName)) {
                    deserializedNotificationRegistrationProperties.messageScope = MessageScope.fromString(reader.getString());
                    continue;
                }
                if ("includedEvents".equals(fieldName)) {
                    List includedEvents;
                    deserializedNotificationRegistrationProperties.includedEvents = includedEvents = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("notificationEndpoints".equals(fieldName)) {
                    List notificationEndpoints;
                    deserializedNotificationRegistrationProperties.notificationEndpoints = notificationEndpoints = reader.readArray(reader1 -> NotificationEndpoint.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedNotificationRegistrationProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNotificationRegistrationProperties;
        });
    }
}

