/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.LoggingDetails;
import com.azure.resourcemanager.providerhub.models.LoggingDirections;
import com.azure.resourcemanager.providerhub.models.LoggingRuleHiddenPropertyPaths;
import java.io.IOException;

public final class LoggingRule
implements JsonSerializable<LoggingRule> {
    private String action;
    private LoggingDirections direction;
    private LoggingDetails detailLevel;
    private LoggingRuleHiddenPropertyPaths hiddenPropertyPaths;
    private static final ClientLogger LOGGER = new ClientLogger(LoggingRule.class);

    public String action() {
        return this.action;
    }

    public LoggingRule withAction(String action) {
        this.action = action;
        return this;
    }

    public LoggingDirections direction() {
        return this.direction;
    }

    public LoggingRule withDirection(LoggingDirections direction) {
        this.direction = direction;
        return this;
    }

    public LoggingDetails detailLevel() {
        return this.detailLevel;
    }

    public LoggingRule withDetailLevel(LoggingDetails detailLevel) {
        this.detailLevel = detailLevel;
        return this;
    }

    public LoggingRuleHiddenPropertyPaths hiddenPropertyPaths() {
        return this.hiddenPropertyPaths;
    }

    public LoggingRule withHiddenPropertyPaths(LoggingRuleHiddenPropertyPaths hiddenPropertyPaths) {
        this.hiddenPropertyPaths = hiddenPropertyPaths;
        return this;
    }

    public void validate() {
        if (this.action() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property action in model LoggingRule"));
        }
        if (this.direction() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property direction in model LoggingRule"));
        }
        if (this.detailLevel() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property detailLevel in model LoggingRule"));
        }
        if (this.hiddenPropertyPaths() != null) {
            this.hiddenPropertyPaths().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("action", this.action);
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        jsonWriter.writeStringField("detailLevel", this.detailLevel == null ? null : this.detailLevel.toString());
        jsonWriter.writeJsonField("hiddenPropertyPaths", (JsonSerializable)this.hiddenPropertyPaths);
        return jsonWriter.writeEndObject();
    }

    public static LoggingRule fromJson(JsonReader jsonReader) throws IOException {
        return (LoggingRule)jsonReader.readObject(reader -> {
            LoggingRule deserializedLoggingRule = new LoggingRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("action".equals(fieldName)) {
                    deserializedLoggingRule.action = reader.getString();
                    continue;
                }
                if ("direction".equals(fieldName)) {
                    deserializedLoggingRule.direction = LoggingDirections.fromString(reader.getString());
                    continue;
                }
                if ("detailLevel".equals(fieldName)) {
                    deserializedLoggingRule.detailLevel = LoggingDetails.fromString(reader.getString());
                    continue;
                }
                if ("hiddenPropertyPaths".equals(fieldName)) {
                    deserializedLoggingRule.hiddenPropertyPaths = LoggingRuleHiddenPropertyPaths.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLoggingRule;
        });
    }
}

