/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.QuotaPolicy;
import java.io.IOException;

public final class LocationQuotaRule
implements JsonSerializable<LocationQuotaRule> {
    private QuotaPolicy policy;
    private String quotaId;
    private String location;

    public QuotaPolicy policy() {
        return this.policy;
    }

    public LocationQuotaRule withPolicy(QuotaPolicy policy) {
        this.policy = policy;
        return this;
    }

    public String quotaId() {
        return this.quotaId;
    }

    public LocationQuotaRule withQuotaId(String quotaId) {
        this.quotaId = quotaId;
        return this;
    }

    public String location() {
        return this.location;
    }

    public LocationQuotaRule withLocation(String location) {
        this.location = location;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("policy", this.policy == null ? null : this.policy.toString());
        jsonWriter.writeStringField("quotaId", this.quotaId);
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    public static LocationQuotaRule fromJson(JsonReader jsonReader) throws IOException {
        return (LocationQuotaRule)jsonReader.readObject(reader -> {
            LocationQuotaRule deserializedLocationQuotaRule = new LocationQuotaRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policy".equals(fieldName)) {
                    deserializedLocationQuotaRule.policy = QuotaPolicy.fromString(reader.getString());
                    continue;
                }
                if ("quotaId".equals(fieldName)) {
                    deserializedLocationQuotaRule.quotaId = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedLocationQuotaRule.location = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLocationQuotaRule;
        });
    }
}

