/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.LocalizedOperationDefinitionDisplay;
import com.azure.resourcemanager.providerhub.models.OperationActionType;
import com.azure.resourcemanager.providerhub.models.OperationOrigins;
import java.io.IOException;

public final class LocalizedOperationDefinition
implements JsonSerializable<LocalizedOperationDefinition> {
    private String name;
    private Boolean isDataAction;
    private OperationOrigins origin;
    private LocalizedOperationDefinitionDisplay display;
    private OperationActionType actionType;
    private static final ClientLogger LOGGER = new ClientLogger(LocalizedOperationDefinition.class);

    public String name() {
        return this.name;
    }

    public LocalizedOperationDefinition withName(String name) {
        this.name = name;
        return this;
    }

    public Boolean isDataAction() {
        return this.isDataAction;
    }

    public LocalizedOperationDefinition withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    public OperationOrigins origin() {
        return this.origin;
    }

    public LocalizedOperationDefinition withOrigin(OperationOrigins origin) {
        this.origin = origin;
        return this;
    }

    public LocalizedOperationDefinitionDisplay display() {
        return this.display;
    }

    public LocalizedOperationDefinition withDisplay(LocalizedOperationDefinitionDisplay display) {
        this.display = display;
        return this;
    }

    public OperationActionType actionType() {
        return this.actionType;
    }

    public LocalizedOperationDefinition withActionType(OperationActionType actionType) {
        this.actionType = actionType;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model LocalizedOperationDefinition"));
        }
        if (this.display() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property display in model LocalizedOperationDefinition"));
        }
        this.display().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        jsonWriter.writeStringField("origin", this.origin == null ? null : this.origin.toString());
        jsonWriter.writeStringField("actionType", this.actionType == null ? null : this.actionType.toString());
        return jsonWriter.writeEndObject();
    }

    public static LocalizedOperationDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (LocalizedOperationDefinition)jsonReader.readObject(reader -> {
            LocalizedOperationDefinition deserializedLocalizedOperationDefinition = new LocalizedOperationDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedLocalizedOperationDefinition.name = reader.getString();
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedLocalizedOperationDefinition.display = LocalizedOperationDefinitionDisplay.fromJson(reader);
                    continue;
                }
                if ("isDataAction".equals(fieldName)) {
                    deserializedLocalizedOperationDefinition.isDataAction = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedLocalizedOperationDefinition.origin = OperationOrigins.fromString(reader.getString());
                    continue;
                }
                if ("actionType".equals(fieldName)) {
                    deserializedLocalizedOperationDefinition.actionType = OperationActionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLocalizedOperationDefinition;
        });
    }
}

