/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.LinkedAction;
import com.azure.resourcemanager.providerhub.models.LinkedOperation;
import java.io.IOException;
import java.util.List;

public final class LinkedOperationRule
implements JsonSerializable<LinkedOperationRule> {
    private LinkedOperation linkedOperation;
    private LinkedAction linkedAction;
    private List<String> dependsOnTypes;
    private static final ClientLogger LOGGER = new ClientLogger(LinkedOperationRule.class);

    public LinkedOperation linkedOperation() {
        return this.linkedOperation;
    }

    public LinkedOperationRule withLinkedOperation(LinkedOperation linkedOperation) {
        this.linkedOperation = linkedOperation;
        return this;
    }

    public LinkedAction linkedAction() {
        return this.linkedAction;
    }

    public LinkedOperationRule withLinkedAction(LinkedAction linkedAction) {
        this.linkedAction = linkedAction;
        return this;
    }

    public List<String> dependsOnTypes() {
        return this.dependsOnTypes;
    }

    public LinkedOperationRule withDependsOnTypes(List<String> dependsOnTypes) {
        this.dependsOnTypes = dependsOnTypes;
        return this;
    }

    public void validate() {
        if (this.linkedOperation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedOperation in model LinkedOperationRule"));
        }
        if (this.linkedAction() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedAction in model LinkedOperationRule"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("linkedOperation", this.linkedOperation == null ? null : this.linkedOperation.toString());
        jsonWriter.writeStringField("linkedAction", this.linkedAction == null ? null : this.linkedAction.toString());
        jsonWriter.writeArrayField("dependsOnTypes", this.dependsOnTypes, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static LinkedOperationRule fromJson(JsonReader jsonReader) throws IOException {
        return (LinkedOperationRule)jsonReader.readObject(reader -> {
            LinkedOperationRule deserializedLinkedOperationRule = new LinkedOperationRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedOperation".equals(fieldName)) {
                    deserializedLinkedOperationRule.linkedOperation = LinkedOperation.fromString(reader.getString());
                    continue;
                }
                if ("linkedAction".equals(fieldName)) {
                    deserializedLinkedOperationRule.linkedAction = LinkedAction.fromString(reader.getString());
                    continue;
                }
                if ("dependsOnTypes".equals(fieldName)) {
                    List dependsOnTypes;
                    deserializedLinkedOperationRule.dependsOnTypes = dependsOnTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinkedOperationRule;
        });
    }
}

