/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class LinkedNotificationRule
implements JsonSerializable<LinkedNotificationRule> {
    private List<String> actions;
    private List<String> actionsOnFailedOperation;
    private List<String> fastPathActions;
    private List<String> fastPathActionsOnFailedOperation;
    private Duration linkedNotificationTimeout;

    public List<String> actions() {
        return this.actions;
    }

    public LinkedNotificationRule withActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    public List<String> actionsOnFailedOperation() {
        return this.actionsOnFailedOperation;
    }

    public LinkedNotificationRule withActionsOnFailedOperation(List<String> actionsOnFailedOperation) {
        this.actionsOnFailedOperation = actionsOnFailedOperation;
        return this;
    }

    public List<String> fastPathActions() {
        return this.fastPathActions;
    }

    public LinkedNotificationRule withFastPathActions(List<String> fastPathActions) {
        this.fastPathActions = fastPathActions;
        return this;
    }

    public List<String> fastPathActionsOnFailedOperation() {
        return this.fastPathActionsOnFailedOperation;
    }

    public LinkedNotificationRule withFastPathActionsOnFailedOperation(List<String> fastPathActionsOnFailedOperation) {
        this.fastPathActionsOnFailedOperation = fastPathActionsOnFailedOperation;
        return this;
    }

    public Duration linkedNotificationTimeout() {
        return this.linkedNotificationTimeout;
    }

    public LinkedNotificationRule withLinkedNotificationTimeout(Duration linkedNotificationTimeout) {
        this.linkedNotificationTimeout = linkedNotificationTimeout;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("actionsOnFailedOperation", this.actionsOnFailedOperation, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("fastPathActions", this.fastPathActions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("fastPathActionsOnFailedOperation", this.fastPathActionsOnFailedOperation, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("linkedNotificationTimeout", CoreUtils.durationToStringWithDays((Duration)this.linkedNotificationTimeout));
        return jsonWriter.writeEndObject();
    }

    public static LinkedNotificationRule fromJson(JsonReader jsonReader) throws IOException {
        return (LinkedNotificationRule)jsonReader.readObject(reader -> {
            LinkedNotificationRule deserializedLinkedNotificationRule = new LinkedNotificationRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedLinkedNotificationRule.actions = actions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("actionsOnFailedOperation".equals(fieldName)) {
                    List actionsOnFailedOperation;
                    deserializedLinkedNotificationRule.actionsOnFailedOperation = actionsOnFailedOperation = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("fastPathActions".equals(fieldName)) {
                    List fastPathActions;
                    deserializedLinkedNotificationRule.fastPathActions = fastPathActions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("fastPathActionsOnFailedOperation".equals(fieldName)) {
                    List fastPathActionsOnFailedOperation;
                    deserializedLinkedNotificationRule.fastPathActionsOnFailedOperation = fastPathActionsOnFailedOperation = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("linkedNotificationTimeout".equals(fieldName)) {
                    deserializedLinkedNotificationRule.linkedNotificationTimeout = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinkedNotificationRule;
        });
    }
}

