/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class LightHouseAuthorization
implements JsonSerializable<LightHouseAuthorization> {
    private String principalId;
    private String roleDefinitionId;
    private static final ClientLogger LOGGER = new ClientLogger(LightHouseAuthorization.class);

    public String principalId() {
        return this.principalId;
    }

    public LightHouseAuthorization withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    public String roleDefinitionId() {
        return this.roleDefinitionId;
    }

    public LightHouseAuthorization withRoleDefinitionId(String roleDefinitionId) {
        this.roleDefinitionId = roleDefinitionId;
        return this;
    }

    public void validate() {
        if (this.principalId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property principalId in model LightHouseAuthorization"));
        }
        if (this.roleDefinitionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property roleDefinitionId in model LightHouseAuthorization"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("principalId", this.principalId);
        jsonWriter.writeStringField("roleDefinitionId", this.roleDefinitionId);
        return jsonWriter.writeEndObject();
    }

    public static LightHouseAuthorization fromJson(JsonReader jsonReader) throws IOException {
        return (LightHouseAuthorization)jsonReader.readObject(reader -> {
            LightHouseAuthorization deserializedLightHouseAuthorization = new LightHouseAuthorization();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("principalId".equals(fieldName)) {
                    deserializedLightHouseAuthorization.principalId = reader.getString();
                    continue;
                }
                if ("roleDefinitionId".equals(fieldName)) {
                    deserializedLightHouseAuthorization.roleDefinitionId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLightHouseAuthorization;
        });
    }
}

