/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.IdentityManagementTypes;
import java.io.IOException;
import java.util.List;

public class IdentityManagementProperties
implements JsonSerializable<IdentityManagementProperties> {
    private IdentityManagementTypes type;
    private String applicationId;
    private List<String> applicationIds;
    private List<String> delegationAppIds;

    public IdentityManagementTypes type() {
        return this.type;
    }

    public IdentityManagementProperties withType(IdentityManagementTypes type) {
        this.type = type;
        return this;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public IdentityManagementProperties withApplicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public List<String> applicationIds() {
        return this.applicationIds;
    }

    public IdentityManagementProperties withApplicationIds(List<String> applicationIds) {
        this.applicationIds = applicationIds;
        return this;
    }

    public List<String> delegationAppIds() {
        return this.delegationAppIds;
    }

    public IdentityManagementProperties withDelegationAppIds(List<String> delegationAppIds) {
        this.delegationAppIds = delegationAppIds;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("applicationId", this.applicationId);
        jsonWriter.writeArrayField("applicationIds", this.applicationIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("delegationAppIds", this.delegationAppIds, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static IdentityManagementProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IdentityManagementProperties)jsonReader.readObject(reader -> {
            IdentityManagementProperties deserializedIdentityManagementProperties = new IdentityManagementProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedIdentityManagementProperties.type = IdentityManagementTypes.fromString(reader.getString());
                    continue;
                }
                if ("applicationId".equals(fieldName)) {
                    deserializedIdentityManagementProperties.applicationId = reader.getString();
                    continue;
                }
                if ("applicationIds".equals(fieldName)) {
                    List applicationIds;
                    deserializedIdentityManagementProperties.applicationIds = applicationIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("delegationAppIds".equals(fieldName)) {
                    List delegationAppIds;
                    deserializedIdentityManagementProperties.delegationAppIds = delegationAppIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdentityManagementProperties;
        });
    }
}

