/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.EndpointType;
import com.azure.resourcemanager.providerhub.models.ResourceTypeEndpointBase;
import com.azure.resourcemanager.providerhub.models.ResourceTypeEndpointBaseDstsConfiguration;
import com.azure.resourcemanager.providerhub.models.ResourceTypeEndpointBaseFeaturesRule;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class FrontloadPayloadPropertiesOverrideEndpointLevelFields
extends ResourceTypeEndpointBase {
    private static final ClientLogger LOGGER = new ClientLogger(FrontloadPayloadPropertiesOverrideEndpointLevelFields.class);

    @Override
    public FrontloadPayloadPropertiesOverrideEndpointLevelFields withEnabled(boolean enabled) {
        super.withEnabled(enabled);
        return this;
    }

    @Override
    public FrontloadPayloadPropertiesOverrideEndpointLevelFields withApiVersions(List<String> apiVersions) {
        super.withApiVersions(apiVersions);
        return this;
    }

    @Override
    public FrontloadPayloadPropertiesOverrideEndpointLevelFields withEndpointUri(String endpointUri) {
        super.withEndpointUri(endpointUri);
        return this;
    }

    @Override
    public FrontloadPayloadPropertiesOverrideEndpointLevelFields withLocations(List<String> locations) {
        super.withLocations(locations);
        return this;
    }

    @Override
    public FrontloadPayloadPropertiesOverrideEndpointLevelFields withRequiredFeatures(List<String> requiredFeatures) {
        super.withRequiredFeatures(requiredFeatures);
        return this;
    }

    @Override
    public FrontloadPayloadPropertiesOverrideEndpointLevelFields withFeaturesRule(ResourceTypeEndpointBaseFeaturesRule featuresRule) {
        super.withFeaturesRule(featuresRule);
        return this;
    }

    @Override
    public FrontloadPayloadPropertiesOverrideEndpointLevelFields withTimeout(Duration timeout) {
        super.withTimeout(timeout);
        return this;
    }

    @Override
    public FrontloadPayloadPropertiesOverrideEndpointLevelFields withEndpointType(EndpointType endpointType) {
        super.withEndpointType(endpointType);
        return this;
    }

    @Override
    public FrontloadPayloadPropertiesOverrideEndpointLevelFields withDstsConfiguration(ResourceTypeEndpointBaseDstsConfiguration dstsConfiguration) {
        super.withDstsConfiguration(dstsConfiguration);
        return this;
    }

    @Override
    public FrontloadPayloadPropertiesOverrideEndpointLevelFields withSkuLink(String skuLink) {
        super.withSkuLink(skuLink);
        return this;
    }

    @Override
    public FrontloadPayloadPropertiesOverrideEndpointLevelFields withApiVersion(String apiVersion) {
        super.withApiVersion(apiVersion);
        return this;
    }

    @Override
    public FrontloadPayloadPropertiesOverrideEndpointLevelFields withZones(List<String> zones) {
        super.withZones(zones);
        return this;
    }

    @Override
    public void validate() {
        if (this.apiVersions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property apiVersions in model FrontloadPayloadPropertiesOverrideEndpointLevelFields"));
        }
        if (this.endpointUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endpointUri in model FrontloadPayloadPropertiesOverrideEndpointLevelFields"));
        }
        if (this.locations() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property locations in model FrontloadPayloadPropertiesOverrideEndpointLevelFields"));
        }
        if (this.requiredFeatures() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property requiredFeatures in model FrontloadPayloadPropertiesOverrideEndpointLevelFields"));
        }
        if (this.featuresRule() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property featuresRule in model FrontloadPayloadPropertiesOverrideEndpointLevelFields"));
        }
        this.featuresRule().validate();
        if (this.timeout() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property timeout in model FrontloadPayloadPropertiesOverrideEndpointLevelFields"));
        }
        if (this.endpointType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endpointType in model FrontloadPayloadPropertiesOverrideEndpointLevelFields"));
        }
        if (this.dstsConfiguration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dstsConfiguration in model FrontloadPayloadPropertiesOverrideEndpointLevelFields"));
        }
        this.dstsConfiguration().validate();
        if (this.skuLink() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property skuLink in model FrontloadPayloadPropertiesOverrideEndpointLevelFields"));
        }
        if (this.apiVersion() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property apiVersion in model FrontloadPayloadPropertiesOverrideEndpointLevelFields"));
        }
        if (this.zones() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property zones in model FrontloadPayloadPropertiesOverrideEndpointLevelFields"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled());
        jsonWriter.writeArrayField("apiVersions", this.apiVersions(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("endpointUri", this.endpointUri());
        jsonWriter.writeArrayField("locations", this.locations(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("requiredFeatures", this.requiredFeatures(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("featuresRule", (JsonSerializable)this.featuresRule());
        jsonWriter.writeStringField("timeout", CoreUtils.durationToStringWithDays((Duration)this.timeout()));
        jsonWriter.writeStringField("endpointType", this.endpointType() == null ? null : this.endpointType().toString());
        jsonWriter.writeJsonField("dstsConfiguration", (JsonSerializable)this.dstsConfiguration());
        jsonWriter.writeStringField("skuLink", this.skuLink());
        jsonWriter.writeStringField("apiVersion", this.apiVersion());
        jsonWriter.writeArrayField("zones", this.zones(), (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static FrontloadPayloadPropertiesOverrideEndpointLevelFields fromJson(JsonReader jsonReader) throws IOException {
        return (FrontloadPayloadPropertiesOverrideEndpointLevelFields)jsonReader.readObject(reader -> {
            FrontloadPayloadPropertiesOverrideEndpointLevelFields deserializedFrontloadPayloadPropertiesOverrideEndpointLevelFields = new FrontloadPayloadPropertiesOverrideEndpointLevelFields();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedFrontloadPayloadPropertiesOverrideEndpointLevelFields.withEnabled(reader.getBoolean());
                    continue;
                }
                if ("apiVersions".equals(fieldName)) {
                    List apiVersions = reader.readArray(reader1 -> reader1.getString());
                    deserializedFrontloadPayloadPropertiesOverrideEndpointLevelFields.withApiVersions(apiVersions);
                    continue;
                }
                if ("endpointUri".equals(fieldName)) {
                    deserializedFrontloadPayloadPropertiesOverrideEndpointLevelFields.withEndpointUri(reader.getString());
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations = reader.readArray(reader1 -> reader1.getString());
                    deserializedFrontloadPayloadPropertiesOverrideEndpointLevelFields.withLocations(locations);
                    continue;
                }
                if ("requiredFeatures".equals(fieldName)) {
                    List requiredFeatures = reader.readArray(reader1 -> reader1.getString());
                    deserializedFrontloadPayloadPropertiesOverrideEndpointLevelFields.withRequiredFeatures(requiredFeatures);
                    continue;
                }
                if ("featuresRule".equals(fieldName)) {
                    deserializedFrontloadPayloadPropertiesOverrideEndpointLevelFields.withFeaturesRule(ResourceTypeEndpointBaseFeaturesRule.fromJson(reader));
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    deserializedFrontloadPayloadPropertiesOverrideEndpointLevelFields.withTimeout((Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString())));
                    continue;
                }
                if ("endpointType".equals(fieldName)) {
                    deserializedFrontloadPayloadPropertiesOverrideEndpointLevelFields.withEndpointType(EndpointType.fromString(reader.getString()));
                    continue;
                }
                if ("dstsConfiguration".equals(fieldName)) {
                    deserializedFrontloadPayloadPropertiesOverrideEndpointLevelFields.withDstsConfiguration(ResourceTypeEndpointBaseDstsConfiguration.fromJson(reader));
                    continue;
                }
                if ("skuLink".equals(fieldName)) {
                    deserializedFrontloadPayloadPropertiesOverrideEndpointLevelFields.withSkuLink(reader.getString());
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    deserializedFrontloadPayloadPropertiesOverrideEndpointLevelFields.withApiVersion(reader.getString());
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones = reader.readArray(reader1 -> reader1.getString());
                    deserializedFrontloadPayloadPropertiesOverrideEndpointLevelFields.withZones(zones);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFrontloadPayloadPropertiesOverrideEndpointLevelFields;
        });
    }
}

