/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.AvailableCheckInManifestEnvironment;
import com.azure.resourcemanager.providerhub.models.FrontloadPayloadPropertiesOverrideEndpointLevelFields;
import com.azure.resourcemanager.providerhub.models.FrontloadPayloadPropertiesOverrideManifestLevelFields;
import com.azure.resourcemanager.providerhub.models.ServiceFeatureFlagAction;
import java.io.IOException;
import java.util.List;

public final class FrontloadPayloadProperties
implements JsonSerializable<FrontloadPayloadProperties> {
    private String operationType;
    private String providerNamespace;
    private String frontloadLocation;
    private String copyFromLocation;
    private AvailableCheckInManifestEnvironment environmentType;
    private ServiceFeatureFlagAction serviceFeatureFlag;
    private List<String> includeResourceTypes;
    private List<String> excludeResourceTypes;
    private FrontloadPayloadPropertiesOverrideManifestLevelFields overrideManifestLevelFields;
    private FrontloadPayloadPropertiesOverrideEndpointLevelFields overrideEndpointLevelFields;
    private List<String> ignoreFields;
    private static final ClientLogger LOGGER = new ClientLogger(FrontloadPayloadProperties.class);

    public String operationType() {
        return this.operationType;
    }

    public FrontloadPayloadProperties withOperationType(String operationType) {
        this.operationType = operationType;
        return this;
    }

    public String providerNamespace() {
        return this.providerNamespace;
    }

    public FrontloadPayloadProperties withProviderNamespace(String providerNamespace) {
        this.providerNamespace = providerNamespace;
        return this;
    }

    public String frontloadLocation() {
        return this.frontloadLocation;
    }

    public FrontloadPayloadProperties withFrontloadLocation(String frontloadLocation) {
        this.frontloadLocation = frontloadLocation;
        return this;
    }

    public String copyFromLocation() {
        return this.copyFromLocation;
    }

    public FrontloadPayloadProperties withCopyFromLocation(String copyFromLocation) {
        this.copyFromLocation = copyFromLocation;
        return this;
    }

    public AvailableCheckInManifestEnvironment environmentType() {
        return this.environmentType;
    }

    public FrontloadPayloadProperties withEnvironmentType(AvailableCheckInManifestEnvironment environmentType) {
        this.environmentType = environmentType;
        return this;
    }

    public ServiceFeatureFlagAction serviceFeatureFlag() {
        return this.serviceFeatureFlag;
    }

    public FrontloadPayloadProperties withServiceFeatureFlag(ServiceFeatureFlagAction serviceFeatureFlag) {
        this.serviceFeatureFlag = serviceFeatureFlag;
        return this;
    }

    public List<String> includeResourceTypes() {
        return this.includeResourceTypes;
    }

    public FrontloadPayloadProperties withIncludeResourceTypes(List<String> includeResourceTypes) {
        this.includeResourceTypes = includeResourceTypes;
        return this;
    }

    public List<String> excludeResourceTypes() {
        return this.excludeResourceTypes;
    }

    public FrontloadPayloadProperties withExcludeResourceTypes(List<String> excludeResourceTypes) {
        this.excludeResourceTypes = excludeResourceTypes;
        return this;
    }

    public FrontloadPayloadPropertiesOverrideManifestLevelFields overrideManifestLevelFields() {
        return this.overrideManifestLevelFields;
    }

    public FrontloadPayloadProperties withOverrideManifestLevelFields(FrontloadPayloadPropertiesOverrideManifestLevelFields overrideManifestLevelFields) {
        this.overrideManifestLevelFields = overrideManifestLevelFields;
        return this;
    }

    public FrontloadPayloadPropertiesOverrideEndpointLevelFields overrideEndpointLevelFields() {
        return this.overrideEndpointLevelFields;
    }

    public FrontloadPayloadProperties withOverrideEndpointLevelFields(FrontloadPayloadPropertiesOverrideEndpointLevelFields overrideEndpointLevelFields) {
        this.overrideEndpointLevelFields = overrideEndpointLevelFields;
        return this;
    }

    public List<String> ignoreFields() {
        return this.ignoreFields;
    }

    public FrontloadPayloadProperties withIgnoreFields(List<String> ignoreFields) {
        this.ignoreFields = ignoreFields;
        return this;
    }

    public void validate() {
        if (this.operationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operationType in model FrontloadPayloadProperties"));
        }
        if (this.providerNamespace() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property providerNamespace in model FrontloadPayloadProperties"));
        }
        if (this.frontloadLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property frontloadLocation in model FrontloadPayloadProperties"));
        }
        if (this.copyFromLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property copyFromLocation in model FrontloadPayloadProperties"));
        }
        if (this.environmentType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property environmentType in model FrontloadPayloadProperties"));
        }
        if (this.serviceFeatureFlag() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serviceFeatureFlag in model FrontloadPayloadProperties"));
        }
        if (this.includeResourceTypes() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property includeResourceTypes in model FrontloadPayloadProperties"));
        }
        if (this.excludeResourceTypes() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property excludeResourceTypes in model FrontloadPayloadProperties"));
        }
        if (this.overrideManifestLevelFields() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property overrideManifestLevelFields in model FrontloadPayloadProperties"));
        }
        this.overrideManifestLevelFields().validate();
        if (this.overrideEndpointLevelFields() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property overrideEndpointLevelFields in model FrontloadPayloadProperties"));
        }
        this.overrideEndpointLevelFields().validate();
        if (this.ignoreFields() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ignoreFields in model FrontloadPayloadProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operationType", this.operationType);
        jsonWriter.writeStringField("providerNamespace", this.providerNamespace);
        jsonWriter.writeStringField("frontloadLocation", this.frontloadLocation);
        jsonWriter.writeStringField("copyFromLocation", this.copyFromLocation);
        jsonWriter.writeStringField("environmentType", this.environmentType == null ? null : this.environmentType.toString());
        jsonWriter.writeStringField("serviceFeatureFlag", this.serviceFeatureFlag == null ? null : this.serviceFeatureFlag.toString());
        jsonWriter.writeArrayField("includeResourceTypes", this.includeResourceTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("excludeResourceTypes", this.excludeResourceTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("overrideManifestLevelFields", (JsonSerializable)this.overrideManifestLevelFields);
        jsonWriter.writeJsonField("overrideEndpointLevelFields", (JsonSerializable)this.overrideEndpointLevelFields);
        jsonWriter.writeArrayField("ignoreFields", this.ignoreFields, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static FrontloadPayloadProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FrontloadPayloadProperties)jsonReader.readObject(reader -> {
            FrontloadPayloadProperties deserializedFrontloadPayloadProperties = new FrontloadPayloadProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationType".equals(fieldName)) {
                    deserializedFrontloadPayloadProperties.operationType = reader.getString();
                    continue;
                }
                if ("providerNamespace".equals(fieldName)) {
                    deserializedFrontloadPayloadProperties.providerNamespace = reader.getString();
                    continue;
                }
                if ("frontloadLocation".equals(fieldName)) {
                    deserializedFrontloadPayloadProperties.frontloadLocation = reader.getString();
                    continue;
                }
                if ("copyFromLocation".equals(fieldName)) {
                    deserializedFrontloadPayloadProperties.copyFromLocation = reader.getString();
                    continue;
                }
                if ("environmentType".equals(fieldName)) {
                    deserializedFrontloadPayloadProperties.environmentType = AvailableCheckInManifestEnvironment.fromString(reader.getString());
                    continue;
                }
                if ("serviceFeatureFlag".equals(fieldName)) {
                    deserializedFrontloadPayloadProperties.serviceFeatureFlag = ServiceFeatureFlagAction.fromString(reader.getString());
                    continue;
                }
                if ("includeResourceTypes".equals(fieldName)) {
                    List includeResourceTypes;
                    deserializedFrontloadPayloadProperties.includeResourceTypes = includeResourceTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("excludeResourceTypes".equals(fieldName)) {
                    List excludeResourceTypes;
                    deserializedFrontloadPayloadProperties.excludeResourceTypes = excludeResourceTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("overrideManifestLevelFields".equals(fieldName)) {
                    deserializedFrontloadPayloadProperties.overrideManifestLevelFields = FrontloadPayloadPropertiesOverrideManifestLevelFields.fromJson(reader);
                    continue;
                }
                if ("overrideEndpointLevelFields".equals(fieldName)) {
                    deserializedFrontloadPayloadProperties.overrideEndpointLevelFields = FrontloadPayloadPropertiesOverrideEndpointLevelFields.fromJson(reader);
                    continue;
                }
                if ("ignoreFields".equals(fieldName)) {
                    List ignoreFields;
                    deserializedFrontloadPayloadProperties.ignoreFields = ignoreFields = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFrontloadPayloadProperties;
        });
    }
}

