/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.EndpointInformation;
import java.io.IOException;
import java.util.List;

public final class FilterRule
implements JsonSerializable<FilterRule> {
    private String filterQuery;
    private List<EndpointInformation> endpointInformation;

    public String filterQuery() {
        return this.filterQuery;
    }

    public FilterRule withFilterQuery(String filterQuery) {
        this.filterQuery = filterQuery;
        return this;
    }

    public List<EndpointInformation> endpointInformation() {
        return this.endpointInformation;
    }

    public FilterRule withEndpointInformation(List<EndpointInformation> endpointInformation) {
        this.endpointInformation = endpointInformation;
        return this;
    }

    public void validate() {
        if (this.endpointInformation() != null) {
            this.endpointInformation().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("filterQuery", this.filterQuery);
        jsonWriter.writeArrayField("endpointInformation", this.endpointInformation, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static FilterRule fromJson(JsonReader jsonReader) throws IOException {
        return (FilterRule)jsonReader.readObject(reader -> {
            FilterRule deserializedFilterRule = new FilterRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filterQuery".equals(fieldName)) {
                    deserializedFilterRule.filterQuery = reader.getString();
                    continue;
                }
                if ("endpointInformation".equals(fieldName)) {
                    List endpointInformation;
                    deserializedFilterRule.endpointInformation = endpointInformation = reader.readArray(reader1 -> EndpointInformation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFilterRule;
        });
    }
}

