/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.FeaturesPolicy;
import java.io.IOException;

public class FeaturesRule
implements JsonSerializable<FeaturesRule> {
    private FeaturesPolicy requiredFeaturesPolicy;
    private static final ClientLogger LOGGER = new ClientLogger(FeaturesRule.class);

    public FeaturesPolicy requiredFeaturesPolicy() {
        return this.requiredFeaturesPolicy;
    }

    public FeaturesRule withRequiredFeaturesPolicy(FeaturesPolicy requiredFeaturesPolicy) {
        this.requiredFeaturesPolicy = requiredFeaturesPolicy;
        return this;
    }

    public void validate() {
        if (this.requiredFeaturesPolicy() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property requiredFeaturesPolicy in model FeaturesRule"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("requiredFeaturesPolicy", this.requiredFeaturesPolicy == null ? null : this.requiredFeaturesPolicy.toString());
        return jsonWriter.writeEndObject();
    }

    public static FeaturesRule fromJson(JsonReader jsonReader) throws IOException {
        return (FeaturesRule)jsonReader.readObject(reader -> {
            FeaturesRule deserializedFeaturesRule = new FeaturesRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("requiredFeaturesPolicy".equals(fieldName)) {
                    deserializedFeaturesRule.requiredFeaturesPolicy = FeaturesPolicy.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFeaturesRule;
        });
    }
}

