/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.FanoutLinkedNotificationRuleDstsConfiguration;
import com.azure.resourcemanager.providerhub.models.ResourceProviderEndpoint;
import com.azure.resourcemanager.providerhub.models.TokenAuthConfiguration;
import java.io.IOException;
import java.util.List;

public final class FanoutLinkedNotificationRule
implements JsonSerializable<FanoutLinkedNotificationRule> {
    private TokenAuthConfiguration tokenAuthConfiguration;
    private List<String> actions;
    private List<ResourceProviderEndpoint> endpoints;
    private FanoutLinkedNotificationRuleDstsConfiguration dstsConfiguration;

    public TokenAuthConfiguration tokenAuthConfiguration() {
        return this.tokenAuthConfiguration;
    }

    public FanoutLinkedNotificationRule withTokenAuthConfiguration(TokenAuthConfiguration tokenAuthConfiguration) {
        this.tokenAuthConfiguration = tokenAuthConfiguration;
        return this;
    }

    public List<String> actions() {
        return this.actions;
    }

    public FanoutLinkedNotificationRule withActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    public List<ResourceProviderEndpoint> endpoints() {
        return this.endpoints;
    }

    public FanoutLinkedNotificationRule withEndpoints(List<ResourceProviderEndpoint> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public FanoutLinkedNotificationRuleDstsConfiguration dstsConfiguration() {
        return this.dstsConfiguration;
    }

    public FanoutLinkedNotificationRule withDstsConfiguration(FanoutLinkedNotificationRuleDstsConfiguration dstsConfiguration) {
        this.dstsConfiguration = dstsConfiguration;
        return this;
    }

    public void validate() {
        if (this.tokenAuthConfiguration() != null) {
            this.tokenAuthConfiguration().validate();
        }
        if (this.endpoints() != null) {
            this.endpoints().forEach(e -> e.validate());
        }
        if (this.dstsConfiguration() != null) {
            this.dstsConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("tokenAuthConfiguration", (JsonSerializable)this.tokenAuthConfiguration);
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("endpoints", this.endpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("dstsConfiguration", (JsonSerializable)this.dstsConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static FanoutLinkedNotificationRule fromJson(JsonReader jsonReader) throws IOException {
        return (FanoutLinkedNotificationRule)jsonReader.readObject(reader -> {
            FanoutLinkedNotificationRule deserializedFanoutLinkedNotificationRule = new FanoutLinkedNotificationRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tokenAuthConfiguration".equals(fieldName)) {
                    deserializedFanoutLinkedNotificationRule.tokenAuthConfiguration = TokenAuthConfiguration.fromJson(reader);
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedFanoutLinkedNotificationRule.actions = actions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("endpoints".equals(fieldName)) {
                    List endpoints;
                    deserializedFanoutLinkedNotificationRule.endpoints = endpoints = reader.readArray(reader1 -> ResourceProviderEndpoint.fromJson(reader1));
                    continue;
                }
                if ("dstsConfiguration".equals(fieldName)) {
                    deserializedFanoutLinkedNotificationRule.dstsConfiguration = FanoutLinkedNotificationRuleDstsConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFanoutLinkedNotificationRule;
        });
    }
}

