/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.TypedErrorInfo;
import java.io.IOException;
import java.util.List;

public final class ExtendedErrorInfo
implements JsonSerializable<ExtendedErrorInfo> {
    private String code;
    private String target;
    private String message;
    private List<ExtendedErrorInfo> details;
    private List<TypedErrorInfo> additionalInfo;

    public String code() {
        return this.code;
    }

    public ExtendedErrorInfo withCode(String code) {
        this.code = code;
        return this;
    }

    public String target() {
        return this.target;
    }

    public ExtendedErrorInfo withTarget(String target) {
        this.target = target;
        return this;
    }

    public String message() {
        return this.message;
    }

    public ExtendedErrorInfo withMessage(String message) {
        this.message = message;
        return this;
    }

    public List<ExtendedErrorInfo> details() {
        return this.details;
    }

    public ExtendedErrorInfo withDetails(List<ExtendedErrorInfo> details) {
        this.details = details;
        return this;
    }

    public List<TypedErrorInfo> additionalInfo() {
        return this.additionalInfo;
    }

    public ExtendedErrorInfo withAdditionalInfo(List<TypedErrorInfo> additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    public void validate() {
        if (this.details() != null) {
            this.details().forEach(e -> e.validate());
        }
        if (this.additionalInfo() != null) {
            this.additionalInfo().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("additionalInfo", this.additionalInfo, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ExtendedErrorInfo fromJson(JsonReader jsonReader) throws IOException {
        return (ExtendedErrorInfo)jsonReader.readObject(reader -> {
            ExtendedErrorInfo deserializedExtendedErrorInfo = new ExtendedErrorInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedExtendedErrorInfo.code = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedExtendedErrorInfo.target = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedExtendedErrorInfo.message = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedExtendedErrorInfo.details = details = reader.readArray(reader1 -> ExtendedErrorInfo.fromJson(reader1));
                    continue;
                }
                if ("additionalInfo".equals(fieldName)) {
                    List additionalInfo;
                    deserializedExtendedErrorInfo.additionalInfo = additionalInfo = reader.readArray(reader1 -> TypedErrorInfo.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExtendedErrorInfo;
        });
    }
}

