/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.NotificationEndpointType;
import java.io.IOException;

public final class EndpointInformation
implements JsonSerializable<EndpointInformation> {
    private String endpoint;
    private NotificationEndpointType endpointType;
    private String schemaVersion;

    public String endpoint() {
        return this.endpoint;
    }

    public EndpointInformation withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public NotificationEndpointType endpointType() {
        return this.endpointType;
    }

    public EndpointInformation withEndpointType(NotificationEndpointType endpointType) {
        this.endpointType = endpointType;
        return this;
    }

    public String schemaVersion() {
        return this.schemaVersion;
    }

    public EndpointInformation withSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpoint", this.endpoint);
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        jsonWriter.writeStringField("schemaVersion", this.schemaVersion);
        return jsonWriter.writeEndObject();
    }

    public static EndpointInformation fromJson(JsonReader jsonReader) throws IOException {
        return (EndpointInformation)jsonReader.readObject(reader -> {
            EndpointInformation deserializedEndpointInformation = new EndpointInformation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpoint".equals(fieldName)) {
                    deserializedEndpointInformation.endpoint = reader.getString();
                    continue;
                }
                if ("endpointType".equals(fieldName)) {
                    deserializedEndpointInformation.endpointType = NotificationEndpointType.fromString(reader.getString());
                    continue;
                }
                if ("schemaVersion".equals(fieldName)) {
                    deserializedEndpointInformation.schemaVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEndpointInformation;
        });
    }
}

