/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class DstsConfiguration
implements JsonSerializable<DstsConfiguration> {
    private String serviceName;
    private String serviceDnsName;
    private static final ClientLogger LOGGER = new ClientLogger(DstsConfiguration.class);

    public String serviceName() {
        return this.serviceName;
    }

    public DstsConfiguration withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public String serviceDnsName() {
        return this.serviceDnsName;
    }

    public DstsConfiguration withServiceDnsName(String serviceDnsName) {
        this.serviceDnsName = serviceDnsName;
        return this;
    }

    public void validate() {
        if (this.serviceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serviceName in model DstsConfiguration"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceName", this.serviceName);
        jsonWriter.writeStringField("serviceDnsName", this.serviceDnsName);
        return jsonWriter.writeEndObject();
    }

    public static DstsConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (DstsConfiguration)jsonReader.readObject(reader -> {
            DstsConfiguration deserializedDstsConfiguration = new DstsConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceName".equals(fieldName)) {
                    deserializedDstsConfiguration.serviceName = reader.getString();
                    continue;
                }
                if ("serviceDnsName".equals(fieldName)) {
                    deserializedDstsConfiguration.serviceDnsName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDstsConfiguration;
        });
    }
}

