/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.DefaultRolloutStatusManifestCheckinStatus;
import com.azure.resourcemanager.providerhub.models.ExtendedErrorInfo;
import com.azure.resourcemanager.providerhub.models.RolloutStatusBase;
import com.azure.resourcemanager.providerhub.models.SubscriptionReregistrationResult;
import com.azure.resourcemanager.providerhub.models.TrafficRegionCategory;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public class DefaultRolloutStatus
extends RolloutStatusBase {
    private TrafficRegionCategory nextTrafficRegion;
    private OffsetDateTime nextTrafficRegionScheduledTime;
    private SubscriptionReregistrationResult subscriptionReregistrationResult;
    private DefaultRolloutStatusManifestCheckinStatus manifestCheckinStatus;

    public TrafficRegionCategory nextTrafficRegion() {
        return this.nextTrafficRegion;
    }

    public DefaultRolloutStatus withNextTrafficRegion(TrafficRegionCategory nextTrafficRegion) {
        this.nextTrafficRegion = nextTrafficRegion;
        return this;
    }

    public OffsetDateTime nextTrafficRegionScheduledTime() {
        return this.nextTrafficRegionScheduledTime;
    }

    public DefaultRolloutStatus withNextTrafficRegionScheduledTime(OffsetDateTime nextTrafficRegionScheduledTime) {
        this.nextTrafficRegionScheduledTime = nextTrafficRegionScheduledTime;
        return this;
    }

    public SubscriptionReregistrationResult subscriptionReregistrationResult() {
        return this.subscriptionReregistrationResult;
    }

    public DefaultRolloutStatus withSubscriptionReregistrationResult(SubscriptionReregistrationResult subscriptionReregistrationResult) {
        this.subscriptionReregistrationResult = subscriptionReregistrationResult;
        return this;
    }

    public DefaultRolloutStatusManifestCheckinStatus manifestCheckinStatus() {
        return this.manifestCheckinStatus;
    }

    public DefaultRolloutStatus withManifestCheckinStatus(DefaultRolloutStatusManifestCheckinStatus manifestCheckinStatus) {
        this.manifestCheckinStatus = manifestCheckinStatus;
        return this;
    }

    @Override
    public DefaultRolloutStatus withCompletedRegions(List<String> completedRegions) {
        super.withCompletedRegions(completedRegions);
        return this;
    }

    @Override
    public DefaultRolloutStatus withFailedOrSkippedRegions(Map<String, ExtendedErrorInfo> failedOrSkippedRegions) {
        super.withFailedOrSkippedRegions(failedOrSkippedRegions);
        return this;
    }

    @Override
    public void validate() {
        if (this.manifestCheckinStatus() != null) {
            this.manifestCheckinStatus().validate();
        }
        if (this.failedOrSkippedRegions() != null) {
            this.failedOrSkippedRegions().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("completedRegions", this.completedRegions(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("failedOrSkippedRegions", this.failedOrSkippedRegions(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextTrafficRegion", this.nextTrafficRegion == null ? null : this.nextTrafficRegion.toString());
        jsonWriter.writeStringField("nextTrafficRegionScheduledTime", this.nextTrafficRegionScheduledTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.nextTrafficRegionScheduledTime));
        jsonWriter.writeStringField("subscriptionReregistrationResult", this.subscriptionReregistrationResult == null ? null : this.subscriptionReregistrationResult.toString());
        jsonWriter.writeJsonField("manifestCheckinStatus", (JsonSerializable)this.manifestCheckinStatus);
        return jsonWriter.writeEndObject();
    }

    public static DefaultRolloutStatus fromJson(JsonReader jsonReader) throws IOException {
        return (DefaultRolloutStatus)jsonReader.readObject(reader -> {
            DefaultRolloutStatus deserializedDefaultRolloutStatus = new DefaultRolloutStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("completedRegions".equals(fieldName)) {
                    List completedRegions = reader.readArray(reader1 -> reader1.getString());
                    deserializedDefaultRolloutStatus.withCompletedRegions(completedRegions);
                    continue;
                }
                if ("failedOrSkippedRegions".equals(fieldName)) {
                    Map failedOrSkippedRegions = reader.readMap(reader1 -> ExtendedErrorInfo.fromJson(reader1));
                    deserializedDefaultRolloutStatus.withFailedOrSkippedRegions(failedOrSkippedRegions);
                    continue;
                }
                if ("nextTrafficRegion".equals(fieldName)) {
                    deserializedDefaultRolloutStatus.nextTrafficRegion = TrafficRegionCategory.fromString(reader.getString());
                    continue;
                }
                if ("nextTrafficRegionScheduledTime".equals(fieldName)) {
                    deserializedDefaultRolloutStatus.nextTrafficRegionScheduledTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("subscriptionReregistrationResult".equals(fieldName)) {
                    deserializedDefaultRolloutStatus.subscriptionReregistrationResult = SubscriptionReregistrationResult.fromString(reader.getString());
                    continue;
                }
                if ("manifestCheckinStatus".equals(fieldName)) {
                    deserializedDefaultRolloutStatus.manifestCheckinStatus = DefaultRolloutStatusManifestCheckinStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDefaultRolloutStatus;
        });
    }
}

