/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.TrafficRegionRolloutConfiguration;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class DefaultRolloutSpecificationLowTraffic
extends TrafficRegionRolloutConfiguration {
    @Override
    public DefaultRolloutSpecificationLowTraffic withWaitDuration(Duration waitDuration) {
        super.withWaitDuration(waitDuration);
        return this;
    }

    @Override
    public DefaultRolloutSpecificationLowTraffic withRegions(List<String> regions) {
        super.withRegions((List)regions);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("regions", this.regions(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("waitDuration", CoreUtils.durationToStringWithDays((Duration)this.waitDuration()));
        return jsonWriter.writeEndObject();
    }

    public static DefaultRolloutSpecificationLowTraffic fromJson(JsonReader jsonReader) throws IOException {
        return (DefaultRolloutSpecificationLowTraffic)jsonReader.readObject(reader -> {
            DefaultRolloutSpecificationLowTraffic deserializedDefaultRolloutSpecificationLowTraffic = new DefaultRolloutSpecificationLowTraffic();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("regions".equals(fieldName)) {
                    List regions = reader.readArray(reader1 -> reader1.getString());
                    deserializedDefaultRolloutSpecificationLowTraffic.withRegions(regions);
                    continue;
                }
                if ("waitDuration".equals(fieldName)) {
                    deserializedDefaultRolloutSpecificationLowTraffic.withWaitDuration((Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString())));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDefaultRolloutSpecificationLowTraffic;
        });
    }
}

