/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.DefaultRolloutStatus;
import com.azure.resourcemanager.providerhub.models.DefaultRolloutStatusManifestCheckinStatus;
import com.azure.resourcemanager.providerhub.models.ExtendedErrorInfo;
import com.azure.resourcemanager.providerhub.models.SubscriptionReregistrationResult;
import com.azure.resourcemanager.providerhub.models.TrafficRegionCategory;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class DefaultRolloutPropertiesStatus
extends DefaultRolloutStatus {
    @Override
    public DefaultRolloutPropertiesStatus withNextTrafficRegion(TrafficRegionCategory nextTrafficRegion) {
        super.withNextTrafficRegion(nextTrafficRegion);
        return this;
    }

    @Override
    public DefaultRolloutPropertiesStatus withNextTrafficRegionScheduledTime(OffsetDateTime nextTrafficRegionScheduledTime) {
        super.withNextTrafficRegionScheduledTime(nextTrafficRegionScheduledTime);
        return this;
    }

    @Override
    public DefaultRolloutPropertiesStatus withSubscriptionReregistrationResult(SubscriptionReregistrationResult subscriptionReregistrationResult) {
        super.withSubscriptionReregistrationResult(subscriptionReregistrationResult);
        return this;
    }

    @Override
    public DefaultRolloutPropertiesStatus withManifestCheckinStatus(DefaultRolloutStatusManifestCheckinStatus manifestCheckinStatus) {
        super.withManifestCheckinStatus(manifestCheckinStatus);
        return this;
    }

    @Override
    public DefaultRolloutPropertiesStatus withCompletedRegions(List<String> completedRegions) {
        super.withCompletedRegions((List)completedRegions);
        return this;
    }

    @Override
    public DefaultRolloutPropertiesStatus withFailedOrSkippedRegions(Map<String, ExtendedErrorInfo> failedOrSkippedRegions) {
        super.withFailedOrSkippedRegions((Map)failedOrSkippedRegions);
        return this;
    }

    @Override
    public void validate() {
        if (this.failedOrSkippedRegions() != null) {
            this.failedOrSkippedRegions().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.manifestCheckinStatus() != null) {
            this.manifestCheckinStatus().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("completedRegions", this.completedRegions(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("failedOrSkippedRegions", this.failedOrSkippedRegions(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextTrafficRegion", this.nextTrafficRegion() == null ? null : this.nextTrafficRegion().toString());
        jsonWriter.writeStringField("nextTrafficRegionScheduledTime", this.nextTrafficRegionScheduledTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.nextTrafficRegionScheduledTime()));
        jsonWriter.writeStringField("subscriptionReregistrationResult", this.subscriptionReregistrationResult() == null ? null : this.subscriptionReregistrationResult().toString());
        jsonWriter.writeJsonField("manifestCheckinStatus", (JsonSerializable)this.manifestCheckinStatus());
        return jsonWriter.writeEndObject();
    }

    public static DefaultRolloutPropertiesStatus fromJson(JsonReader jsonReader) throws IOException {
        return (DefaultRolloutPropertiesStatus)jsonReader.readObject(reader -> {
            DefaultRolloutPropertiesStatus deserializedDefaultRolloutPropertiesStatus = new DefaultRolloutPropertiesStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("completedRegions".equals(fieldName)) {
                    List completedRegions = reader.readArray(reader1 -> reader1.getString());
                    deserializedDefaultRolloutPropertiesStatus.withCompletedRegions(completedRegions);
                    continue;
                }
                if ("failedOrSkippedRegions".equals(fieldName)) {
                    Map failedOrSkippedRegions = reader.readMap(reader1 -> ExtendedErrorInfo.fromJson(reader1));
                    deserializedDefaultRolloutPropertiesStatus.withFailedOrSkippedRegions(failedOrSkippedRegions);
                    continue;
                }
                if ("nextTrafficRegion".equals(fieldName)) {
                    deserializedDefaultRolloutPropertiesStatus.withNextTrafficRegion(TrafficRegionCategory.fromString(reader.getString()));
                    continue;
                }
                if ("nextTrafficRegionScheduledTime".equals(fieldName)) {
                    deserializedDefaultRolloutPropertiesStatus.withNextTrafficRegionScheduledTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("subscriptionReregistrationResult".equals(fieldName)) {
                    deserializedDefaultRolloutPropertiesStatus.withSubscriptionReregistrationResult(SubscriptionReregistrationResult.fromString(reader.getString()));
                    continue;
                }
                if ("manifestCheckinStatus".equals(fieldName)) {
                    deserializedDefaultRolloutPropertiesStatus.withManifestCheckinStatus(DefaultRolloutStatusManifestCheckinStatus.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDefaultRolloutPropertiesStatus;
        });
    }
}

