/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.fluent.models.ResourceTypeRegistrationInner;
import com.azure.resourcemanager.providerhub.models.DefaultRolloutSpecification;
import com.azure.resourcemanager.providerhub.models.DefaultRolloutSpecificationAutoProvisionConfig;
import com.azure.resourcemanager.providerhub.models.DefaultRolloutSpecificationCanary;
import com.azure.resourcemanager.providerhub.models.DefaultRolloutSpecificationExpeditedRollout;
import com.azure.resourcemanager.providerhub.models.DefaultRolloutSpecificationHighTraffic;
import com.azure.resourcemanager.providerhub.models.DefaultRolloutSpecificationLowTraffic;
import com.azure.resourcemanager.providerhub.models.DefaultRolloutSpecificationMediumTraffic;
import com.azure.resourcemanager.providerhub.models.DefaultRolloutSpecificationProviderRegistration;
import com.azure.resourcemanager.providerhub.models.DefaultRolloutSpecificationRestOfTheWorldGroupOne;
import com.azure.resourcemanager.providerhub.models.DefaultRolloutSpecificationRestOfTheWorldGroupTwo;
import java.io.IOException;
import java.util.List;

public final class DefaultRolloutPropertiesSpecification
extends DefaultRolloutSpecification {
    @Override
    public DefaultRolloutPropertiesSpecification withExpeditedRollout(DefaultRolloutSpecificationExpeditedRollout expeditedRollout) {
        super.withExpeditedRollout(expeditedRollout);
        return this;
    }

    @Override
    public DefaultRolloutPropertiesSpecification withCanary(DefaultRolloutSpecificationCanary canary) {
        super.withCanary(canary);
        return this;
    }

    @Override
    public DefaultRolloutPropertiesSpecification withLowTraffic(DefaultRolloutSpecificationLowTraffic lowTraffic) {
        super.withLowTraffic(lowTraffic);
        return this;
    }

    @Override
    public DefaultRolloutPropertiesSpecification withMediumTraffic(DefaultRolloutSpecificationMediumTraffic mediumTraffic) {
        super.withMediumTraffic(mediumTraffic);
        return this;
    }

    @Override
    public DefaultRolloutPropertiesSpecification withHighTraffic(DefaultRolloutSpecificationHighTraffic highTraffic) {
        super.withHighTraffic(highTraffic);
        return this;
    }

    @Override
    public DefaultRolloutPropertiesSpecification withRestOfTheWorldGroupOne(DefaultRolloutSpecificationRestOfTheWorldGroupOne restOfTheWorldGroupOne) {
        super.withRestOfTheWorldGroupOne(restOfTheWorldGroupOne);
        return this;
    }

    @Override
    public DefaultRolloutPropertiesSpecification withRestOfTheWorldGroupTwo(DefaultRolloutSpecificationRestOfTheWorldGroupTwo restOfTheWorldGroupTwo) {
        super.withRestOfTheWorldGroupTwo(restOfTheWorldGroupTwo);
        return this;
    }

    @Override
    public DefaultRolloutPropertiesSpecification withProviderRegistration(DefaultRolloutSpecificationProviderRegistration providerRegistration) {
        super.withProviderRegistration(providerRegistration);
        return this;
    }

    @Override
    public DefaultRolloutPropertiesSpecification withResourceTypeRegistrations(List<ResourceTypeRegistrationInner> resourceTypeRegistrations) {
        super.withResourceTypeRegistrations(resourceTypeRegistrations);
        return this;
    }

    @Override
    public DefaultRolloutPropertiesSpecification withAutoProvisionConfig(DefaultRolloutSpecificationAutoProvisionConfig autoProvisionConfig) {
        super.withAutoProvisionConfig(autoProvisionConfig);
        return this;
    }

    @Override
    public void validate() {
        if (this.expeditedRollout() != null) {
            this.expeditedRollout().validate();
        }
        if (this.canary() != null) {
            this.canary().validate();
        }
        if (this.lowTraffic() != null) {
            this.lowTraffic().validate();
        }
        if (this.mediumTraffic() != null) {
            this.mediumTraffic().validate();
        }
        if (this.highTraffic() != null) {
            this.highTraffic().validate();
        }
        if (this.restOfTheWorldGroupOne() != null) {
            this.restOfTheWorldGroupOne().validate();
        }
        if (this.restOfTheWorldGroupTwo() != null) {
            this.restOfTheWorldGroupTwo().validate();
        }
        if (this.providerRegistration() != null) {
            this.providerRegistration().validate();
        }
        if (this.resourceTypeRegistrations() != null) {
            this.resourceTypeRegistrations().forEach(e -> e.validate());
        }
        if (this.autoProvisionConfig() != null) {
            this.autoProvisionConfig().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("expeditedRollout", (JsonSerializable)this.expeditedRollout());
        jsonWriter.writeJsonField("canary", (JsonSerializable)this.canary());
        jsonWriter.writeJsonField("lowTraffic", (JsonSerializable)this.lowTraffic());
        jsonWriter.writeJsonField("mediumTraffic", (JsonSerializable)this.mediumTraffic());
        jsonWriter.writeJsonField("highTraffic", (JsonSerializable)this.highTraffic());
        jsonWriter.writeJsonField("restOfTheWorldGroupOne", (JsonSerializable)this.restOfTheWorldGroupOne());
        jsonWriter.writeJsonField("restOfTheWorldGroupTwo", (JsonSerializable)this.restOfTheWorldGroupTwo());
        jsonWriter.writeJsonField("providerRegistration", (JsonSerializable)this.providerRegistration());
        jsonWriter.writeArrayField("resourceTypeRegistrations", this.resourceTypeRegistrations(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("autoProvisionConfig", (JsonSerializable)this.autoProvisionConfig());
        return jsonWriter.writeEndObject();
    }

    public static DefaultRolloutPropertiesSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (DefaultRolloutPropertiesSpecification)jsonReader.readObject(reader -> {
            DefaultRolloutPropertiesSpecification deserializedDefaultRolloutPropertiesSpecification = new DefaultRolloutPropertiesSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("expeditedRollout".equals(fieldName)) {
                    deserializedDefaultRolloutPropertiesSpecification.withExpeditedRollout(DefaultRolloutSpecificationExpeditedRollout.fromJson(reader));
                    continue;
                }
                if ("canary".equals(fieldName)) {
                    deserializedDefaultRolloutPropertiesSpecification.withCanary(DefaultRolloutSpecificationCanary.fromJson(reader));
                    continue;
                }
                if ("lowTraffic".equals(fieldName)) {
                    deserializedDefaultRolloutPropertiesSpecification.withLowTraffic(DefaultRolloutSpecificationLowTraffic.fromJson(reader));
                    continue;
                }
                if ("mediumTraffic".equals(fieldName)) {
                    deserializedDefaultRolloutPropertiesSpecification.withMediumTraffic(DefaultRolloutSpecificationMediumTraffic.fromJson(reader));
                    continue;
                }
                if ("highTraffic".equals(fieldName)) {
                    deserializedDefaultRolloutPropertiesSpecification.withHighTraffic(DefaultRolloutSpecificationHighTraffic.fromJson(reader));
                    continue;
                }
                if ("restOfTheWorldGroupOne".equals(fieldName)) {
                    deserializedDefaultRolloutPropertiesSpecification.withRestOfTheWorldGroupOne(DefaultRolloutSpecificationRestOfTheWorldGroupOne.fromJson(reader));
                    continue;
                }
                if ("restOfTheWorldGroupTwo".equals(fieldName)) {
                    deserializedDefaultRolloutPropertiesSpecification.withRestOfTheWorldGroupTwo(DefaultRolloutSpecificationRestOfTheWorldGroupTwo.fromJson(reader));
                    continue;
                }
                if ("providerRegistration".equals(fieldName)) {
                    deserializedDefaultRolloutPropertiesSpecification.withProviderRegistration(DefaultRolloutSpecificationProviderRegistration.fromJson(reader));
                    continue;
                }
                if ("resourceTypeRegistrations".equals(fieldName)) {
                    List resourceTypeRegistrations = reader.readArray(reader1 -> ResourceTypeRegistrationInner.fromJson(reader1));
                    deserializedDefaultRolloutPropertiesSpecification.withResourceTypeRegistrations(resourceTypeRegistrations);
                    continue;
                }
                if ("autoProvisionConfig".equals(fieldName)) {
                    deserializedDefaultRolloutPropertiesSpecification.withAutoProvisionConfig(DefaultRolloutSpecificationAutoProvisionConfig.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDefaultRolloutPropertiesSpecification;
        });
    }
}

