/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.DefaultRolloutPropertiesSpecification;
import com.azure.resourcemanager.providerhub.models.DefaultRolloutPropertiesStatus;
import com.azure.resourcemanager.providerhub.models.ProvisioningState;
import java.io.IOException;

public final class DefaultRolloutProperties
implements JsonSerializable<DefaultRolloutProperties> {
    private ProvisioningState provisioningState;
    private DefaultRolloutPropertiesSpecification specification;
    private DefaultRolloutPropertiesStatus status;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DefaultRolloutPropertiesSpecification specification() {
        return this.specification;
    }

    public DefaultRolloutProperties withSpecification(DefaultRolloutPropertiesSpecification specification) {
        this.specification = specification;
        return this;
    }

    public DefaultRolloutPropertiesStatus status() {
        return this.status;
    }

    public DefaultRolloutProperties withStatus(DefaultRolloutPropertiesStatus status) {
        this.status = status;
        return this;
    }

    public void validate() {
        if (this.specification() != null) {
            this.specification().validate();
        }
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("specification", (JsonSerializable)this.specification);
        jsonWriter.writeJsonField("status", (JsonSerializable)this.status);
        return jsonWriter.writeEndObject();
    }

    public static DefaultRolloutProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DefaultRolloutProperties)jsonReader.readObject(reader -> {
            DefaultRolloutProperties deserializedDefaultRolloutProperties = new DefaultRolloutProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedDefaultRolloutProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("specification".equals(fieldName)) {
                    deserializedDefaultRolloutProperties.specification = DefaultRolloutPropertiesSpecification.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedDefaultRolloutProperties.status = DefaultRolloutPropertiesStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDefaultRolloutProperties;
        });
    }
}

