/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.CustomRolloutStatusManifestCheckinStatus;
import com.azure.resourcemanager.providerhub.models.ExtendedErrorInfo;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class CustomRolloutStatus
implements JsonSerializable<CustomRolloutStatus> {
    private List<String> completedRegions;
    private Map<String, ExtendedErrorInfo> failedOrSkippedRegions;
    private CustomRolloutStatusManifestCheckinStatus manifestCheckinStatus;

    public List<String> completedRegions() {
        return this.completedRegions;
    }

    public CustomRolloutStatus withCompletedRegions(List<String> completedRegions) {
        this.completedRegions = completedRegions;
        return this;
    }

    public Map<String, ExtendedErrorInfo> failedOrSkippedRegions() {
        return this.failedOrSkippedRegions;
    }

    public CustomRolloutStatus withFailedOrSkippedRegions(Map<String, ExtendedErrorInfo> failedOrSkippedRegions) {
        this.failedOrSkippedRegions = failedOrSkippedRegions;
        return this;
    }

    public CustomRolloutStatusManifestCheckinStatus manifestCheckinStatus() {
        return this.manifestCheckinStatus;
    }

    public CustomRolloutStatus withManifestCheckinStatus(CustomRolloutStatusManifestCheckinStatus manifestCheckinStatus) {
        this.manifestCheckinStatus = manifestCheckinStatus;
        return this;
    }

    public void validate() {
        if (this.failedOrSkippedRegions() != null) {
            this.failedOrSkippedRegions().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.manifestCheckinStatus() != null) {
            this.manifestCheckinStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("completedRegions", this.completedRegions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("failedOrSkippedRegions", this.failedOrSkippedRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("manifestCheckinStatus", (JsonSerializable)this.manifestCheckinStatus);
        return jsonWriter.writeEndObject();
    }

    public static CustomRolloutStatus fromJson(JsonReader jsonReader) throws IOException {
        return (CustomRolloutStatus)jsonReader.readObject(reader -> {
            CustomRolloutStatus deserializedCustomRolloutStatus = new CustomRolloutStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("completedRegions".equals(fieldName)) {
                    List completedRegions;
                    deserializedCustomRolloutStatus.completedRegions = completedRegions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("failedOrSkippedRegions".equals(fieldName)) {
                    Map failedOrSkippedRegions;
                    deserializedCustomRolloutStatus.failedOrSkippedRegions = failedOrSkippedRegions = reader.readMap(reader1 -> ExtendedErrorInfo.fromJson(reader1));
                    continue;
                }
                if ("manifestCheckinStatus".equals(fieldName)) {
                    deserializedCustomRolloutStatus.manifestCheckinStatus = CustomRolloutStatusManifestCheckinStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomRolloutStatus;
        });
    }
}

