/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.fluent.models.ProviderRegistrationInner;
import com.azure.resourcemanager.providerhub.models.ProviderRegistrationKind;
import com.azure.resourcemanager.providerhub.models.ProviderRegistrationProperties;
import java.io.IOException;

public final class CustomRolloutSpecificationProviderRegistration
extends ProviderRegistrationInner {
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public CustomRolloutSpecificationProviderRegistration withProperties(ProviderRegistrationProperties properties) {
        super.withProperties(properties);
        return this;
    }

    @Override
    public CustomRolloutSpecificationProviderRegistration withKind(ProviderRegistrationKind kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties());
        jsonWriter.writeStringField("kind", this.kind() == null ? null : this.kind().toString());
        return jsonWriter.writeEndObject();
    }

    public static CustomRolloutSpecificationProviderRegistration fromJson(JsonReader jsonReader) throws IOException {
        return (CustomRolloutSpecificationProviderRegistration)((Object)jsonReader.readObject(reader -> {
            CustomRolloutSpecificationProviderRegistration deserializedCustomRolloutSpecificationProviderRegistration = new CustomRolloutSpecificationProviderRegistration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCustomRolloutSpecificationProviderRegistration.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCustomRolloutSpecificationProviderRegistration.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCustomRolloutSpecificationProviderRegistration.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCustomRolloutSpecificationProviderRegistration.withProperties(ProviderRegistrationProperties.fromJson(reader));
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedCustomRolloutSpecificationProviderRegistration.withKind(ProviderRegistrationKind.fromString(reader.getString()));
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedCustomRolloutSpecificationProviderRegistration.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomRolloutSpecificationProviderRegistration;
        }));
    }
}

