/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.fluent.models.ResourceTypeRegistrationInner;
import com.azure.resourcemanager.providerhub.models.CustomRolloutSpecificationAutoProvisionConfig;
import com.azure.resourcemanager.providerhub.models.CustomRolloutSpecificationCanary;
import com.azure.resourcemanager.providerhub.models.CustomRolloutSpecificationProviderRegistration;
import java.io.IOException;
import java.util.List;

public class CustomRolloutSpecification
implements JsonSerializable<CustomRolloutSpecification> {
    private CustomRolloutSpecificationAutoProvisionConfig autoProvisionConfig;
    private CustomRolloutSpecificationCanary canary;
    private List<String> releaseScopes;
    private Boolean refreshSubscriptionRegistration;
    private Boolean skipReleaseScopeValidation;
    private CustomRolloutSpecificationProviderRegistration providerRegistration;
    private List<ResourceTypeRegistrationInner> resourceTypeRegistrations;

    public CustomRolloutSpecificationAutoProvisionConfig autoProvisionConfig() {
        return this.autoProvisionConfig;
    }

    public CustomRolloutSpecification withAutoProvisionConfig(CustomRolloutSpecificationAutoProvisionConfig autoProvisionConfig) {
        this.autoProvisionConfig = autoProvisionConfig;
        return this;
    }

    public CustomRolloutSpecificationCanary canary() {
        return this.canary;
    }

    public CustomRolloutSpecification withCanary(CustomRolloutSpecificationCanary canary) {
        this.canary = canary;
        return this;
    }

    public List<String> releaseScopes() {
        return this.releaseScopes;
    }

    public CustomRolloutSpecification withReleaseScopes(List<String> releaseScopes) {
        this.releaseScopes = releaseScopes;
        return this;
    }

    public Boolean refreshSubscriptionRegistration() {
        return this.refreshSubscriptionRegistration;
    }

    public CustomRolloutSpecification withRefreshSubscriptionRegistration(Boolean refreshSubscriptionRegistration) {
        this.refreshSubscriptionRegistration = refreshSubscriptionRegistration;
        return this;
    }

    public Boolean skipReleaseScopeValidation() {
        return this.skipReleaseScopeValidation;
    }

    public CustomRolloutSpecification withSkipReleaseScopeValidation(Boolean skipReleaseScopeValidation) {
        this.skipReleaseScopeValidation = skipReleaseScopeValidation;
        return this;
    }

    public CustomRolloutSpecificationProviderRegistration providerRegistration() {
        return this.providerRegistration;
    }

    public CustomRolloutSpecification withProviderRegistration(CustomRolloutSpecificationProviderRegistration providerRegistration) {
        this.providerRegistration = providerRegistration;
        return this;
    }

    public List<ResourceTypeRegistrationInner> resourceTypeRegistrations() {
        return this.resourceTypeRegistrations;
    }

    public CustomRolloutSpecification withResourceTypeRegistrations(List<ResourceTypeRegistrationInner> resourceTypeRegistrations) {
        this.resourceTypeRegistrations = resourceTypeRegistrations;
        return this;
    }

    public void validate() {
        if (this.autoProvisionConfig() != null) {
            this.autoProvisionConfig().validate();
        }
        if (this.canary() != null) {
            this.canary().validate();
        }
        if (this.providerRegistration() != null) {
            this.providerRegistration().validate();
        }
        if (this.resourceTypeRegistrations() != null) {
            this.resourceTypeRegistrations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("autoProvisionConfig", (JsonSerializable)this.autoProvisionConfig);
        jsonWriter.writeJsonField("canary", (JsonSerializable)this.canary);
        jsonWriter.writeArrayField("releaseScopes", this.releaseScopes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("refreshSubscriptionRegistration", this.refreshSubscriptionRegistration);
        jsonWriter.writeBooleanField("skipReleaseScopeValidation", this.skipReleaseScopeValidation);
        jsonWriter.writeJsonField("providerRegistration", (JsonSerializable)this.providerRegistration);
        jsonWriter.writeArrayField("resourceTypeRegistrations", this.resourceTypeRegistrations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CustomRolloutSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (CustomRolloutSpecification)jsonReader.readObject(reader -> {
            CustomRolloutSpecification deserializedCustomRolloutSpecification = new CustomRolloutSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("autoProvisionConfig".equals(fieldName)) {
                    deserializedCustomRolloutSpecification.autoProvisionConfig = CustomRolloutSpecificationAutoProvisionConfig.fromJson(reader);
                    continue;
                }
                if ("canary".equals(fieldName)) {
                    deserializedCustomRolloutSpecification.canary = CustomRolloutSpecificationCanary.fromJson(reader);
                    continue;
                }
                if ("releaseScopes".equals(fieldName)) {
                    List releaseScopes;
                    deserializedCustomRolloutSpecification.releaseScopes = releaseScopes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("refreshSubscriptionRegistration".equals(fieldName)) {
                    deserializedCustomRolloutSpecification.refreshSubscriptionRegistration = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("skipReleaseScopeValidation".equals(fieldName)) {
                    deserializedCustomRolloutSpecification.skipReleaseScopeValidation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("providerRegistration".equals(fieldName)) {
                    deserializedCustomRolloutSpecification.providerRegistration = CustomRolloutSpecificationProviderRegistration.fromJson(reader);
                    continue;
                }
                if ("resourceTypeRegistrations".equals(fieldName)) {
                    List resourceTypeRegistrations;
                    deserializedCustomRolloutSpecification.resourceTypeRegistrations = resourceTypeRegistrations = reader.readArray(reader1 -> ResourceTypeRegistrationInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomRolloutSpecification;
        });
    }
}

