/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.CustomRolloutStatus;
import com.azure.resourcemanager.providerhub.models.CustomRolloutStatusManifestCheckinStatus;
import com.azure.resourcemanager.providerhub.models.ExtendedErrorInfo;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CustomRolloutPropertiesStatus
extends CustomRolloutStatus {
    @Override
    public CustomRolloutPropertiesStatus withCompletedRegions(List<String> completedRegions) {
        super.withCompletedRegions(completedRegions);
        return this;
    }

    @Override
    public CustomRolloutPropertiesStatus withFailedOrSkippedRegions(Map<String, ExtendedErrorInfo> failedOrSkippedRegions) {
        super.withFailedOrSkippedRegions(failedOrSkippedRegions);
        return this;
    }

    @Override
    public CustomRolloutPropertiesStatus withManifestCheckinStatus(CustomRolloutStatusManifestCheckinStatus manifestCheckinStatus) {
        super.withManifestCheckinStatus(manifestCheckinStatus);
        return this;
    }

    @Override
    public void validate() {
        if (this.failedOrSkippedRegions() != null) {
            this.failedOrSkippedRegions().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.manifestCheckinStatus() != null) {
            this.manifestCheckinStatus().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("completedRegions", this.completedRegions(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("failedOrSkippedRegions", this.failedOrSkippedRegions(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("manifestCheckinStatus", (JsonSerializable)this.manifestCheckinStatus());
        return jsonWriter.writeEndObject();
    }

    public static CustomRolloutPropertiesStatus fromJson(JsonReader jsonReader) throws IOException {
        return (CustomRolloutPropertiesStatus)jsonReader.readObject(reader -> {
            CustomRolloutPropertiesStatus deserializedCustomRolloutPropertiesStatus = new CustomRolloutPropertiesStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("completedRegions".equals(fieldName)) {
                    List completedRegions = reader.readArray(reader1 -> reader1.getString());
                    deserializedCustomRolloutPropertiesStatus.withCompletedRegions(completedRegions);
                    continue;
                }
                if ("failedOrSkippedRegions".equals(fieldName)) {
                    Map failedOrSkippedRegions = reader.readMap(reader1 -> ExtendedErrorInfo.fromJson(reader1));
                    deserializedCustomRolloutPropertiesStatus.withFailedOrSkippedRegions(failedOrSkippedRegions);
                    continue;
                }
                if ("manifestCheckinStatus".equals(fieldName)) {
                    deserializedCustomRolloutPropertiesStatus.withManifestCheckinStatus(CustomRolloutStatusManifestCheckinStatus.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomRolloutPropertiesStatus;
        });
    }
}

