/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.fluent.models.ResourceTypeRegistrationInner;
import com.azure.resourcemanager.providerhub.models.CustomRolloutSpecification;
import com.azure.resourcemanager.providerhub.models.CustomRolloutSpecificationAutoProvisionConfig;
import com.azure.resourcemanager.providerhub.models.CustomRolloutSpecificationCanary;
import com.azure.resourcemanager.providerhub.models.CustomRolloutSpecificationProviderRegistration;
import java.io.IOException;
import java.util.List;

public final class CustomRolloutPropertiesSpecification
extends CustomRolloutSpecification {
    @Override
    public CustomRolloutPropertiesSpecification withAutoProvisionConfig(CustomRolloutSpecificationAutoProvisionConfig autoProvisionConfig) {
        super.withAutoProvisionConfig(autoProvisionConfig);
        return this;
    }

    @Override
    public CustomRolloutPropertiesSpecification withCanary(CustomRolloutSpecificationCanary canary) {
        super.withCanary(canary);
        return this;
    }

    @Override
    public CustomRolloutPropertiesSpecification withReleaseScopes(List<String> releaseScopes) {
        super.withReleaseScopes(releaseScopes);
        return this;
    }

    @Override
    public CustomRolloutPropertiesSpecification withRefreshSubscriptionRegistration(Boolean refreshSubscriptionRegistration) {
        super.withRefreshSubscriptionRegistration(refreshSubscriptionRegistration);
        return this;
    }

    @Override
    public CustomRolloutPropertiesSpecification withSkipReleaseScopeValidation(Boolean skipReleaseScopeValidation) {
        super.withSkipReleaseScopeValidation(skipReleaseScopeValidation);
        return this;
    }

    @Override
    public CustomRolloutPropertiesSpecification withProviderRegistration(CustomRolloutSpecificationProviderRegistration providerRegistration) {
        super.withProviderRegistration(providerRegistration);
        return this;
    }

    @Override
    public CustomRolloutPropertiesSpecification withResourceTypeRegistrations(List<ResourceTypeRegistrationInner> resourceTypeRegistrations) {
        super.withResourceTypeRegistrations(resourceTypeRegistrations);
        return this;
    }

    @Override
    public void validate() {
        if (this.autoProvisionConfig() != null) {
            this.autoProvisionConfig().validate();
        }
        if (this.canary() != null) {
            this.canary().validate();
        }
        if (this.providerRegistration() != null) {
            this.providerRegistration().validate();
        }
        if (this.resourceTypeRegistrations() != null) {
            this.resourceTypeRegistrations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("autoProvisionConfig", (JsonSerializable)this.autoProvisionConfig());
        jsonWriter.writeJsonField("canary", (JsonSerializable)this.canary());
        jsonWriter.writeArrayField("releaseScopes", this.releaseScopes(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("refreshSubscriptionRegistration", this.refreshSubscriptionRegistration());
        jsonWriter.writeBooleanField("skipReleaseScopeValidation", this.skipReleaseScopeValidation());
        jsonWriter.writeJsonField("providerRegistration", (JsonSerializable)this.providerRegistration());
        jsonWriter.writeArrayField("resourceTypeRegistrations", this.resourceTypeRegistrations(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CustomRolloutPropertiesSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (CustomRolloutPropertiesSpecification)jsonReader.readObject(reader -> {
            CustomRolloutPropertiesSpecification deserializedCustomRolloutPropertiesSpecification = new CustomRolloutPropertiesSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("autoProvisionConfig".equals(fieldName)) {
                    deserializedCustomRolloutPropertiesSpecification.withAutoProvisionConfig(CustomRolloutSpecificationAutoProvisionConfig.fromJson(reader));
                    continue;
                }
                if ("canary".equals(fieldName)) {
                    deserializedCustomRolloutPropertiesSpecification.withCanary(CustomRolloutSpecificationCanary.fromJson(reader));
                    continue;
                }
                if ("releaseScopes".equals(fieldName)) {
                    List releaseScopes = reader.readArray(reader1 -> reader1.getString());
                    deserializedCustomRolloutPropertiesSpecification.withReleaseScopes(releaseScopes);
                    continue;
                }
                if ("refreshSubscriptionRegistration".equals(fieldName)) {
                    deserializedCustomRolloutPropertiesSpecification.withRefreshSubscriptionRegistration((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("skipReleaseScopeValidation".equals(fieldName)) {
                    deserializedCustomRolloutPropertiesSpecification.withSkipReleaseScopeValidation((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("providerRegistration".equals(fieldName)) {
                    deserializedCustomRolloutPropertiesSpecification.withProviderRegistration(CustomRolloutSpecificationProviderRegistration.fromJson(reader));
                    continue;
                }
                if ("resourceTypeRegistrations".equals(fieldName)) {
                    List resourceTypeRegistrations = reader.readArray(reader1 -> ResourceTypeRegistrationInner.fromJson(reader1));
                    deserializedCustomRolloutPropertiesSpecification.withResourceTypeRegistrations(resourceTypeRegistrations);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomRolloutPropertiesSpecification;
        });
    }
}

