/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.CustomRolloutPropertiesSpecification;
import com.azure.resourcemanager.providerhub.models.CustomRolloutPropertiesStatus;
import com.azure.resourcemanager.providerhub.models.ProvisioningState;
import java.io.IOException;

public final class CustomRolloutProperties
implements JsonSerializable<CustomRolloutProperties> {
    private ProvisioningState provisioningState;
    private CustomRolloutPropertiesSpecification specification;
    private CustomRolloutPropertiesStatus status;
    private static final ClientLogger LOGGER = new ClientLogger(CustomRolloutProperties.class);

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public CustomRolloutPropertiesSpecification specification() {
        return this.specification;
    }

    public CustomRolloutProperties withSpecification(CustomRolloutPropertiesSpecification specification) {
        this.specification = specification;
        return this;
    }

    public CustomRolloutPropertiesStatus status() {
        return this.status;
    }

    public CustomRolloutProperties withStatus(CustomRolloutPropertiesStatus status) {
        this.status = status;
        return this;
    }

    public void validate() {
        if (this.specification() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property specification in model CustomRolloutProperties"));
        }
        this.specification().validate();
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("specification", (JsonSerializable)this.specification);
        jsonWriter.writeJsonField("status", (JsonSerializable)this.status);
        return jsonWriter.writeEndObject();
    }

    public static CustomRolloutProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CustomRolloutProperties)jsonReader.readObject(reader -> {
            CustomRolloutProperties deserializedCustomRolloutProperties = new CustomRolloutProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("specification".equals(fieldName)) {
                    deserializedCustomRolloutProperties.specification = CustomRolloutPropertiesSpecification.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCustomRolloutProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedCustomRolloutProperties.status = CustomRolloutPropertiesStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomRolloutProperties;
        });
    }
}

