/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CheckinManifestParams
implements JsonSerializable<CheckinManifestParams> {
    private String environment;
    private String baselineArmManifestLocation;
    private static final ClientLogger LOGGER = new ClientLogger(CheckinManifestParams.class);

    public String environment() {
        return this.environment;
    }

    public CheckinManifestParams withEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    public String baselineArmManifestLocation() {
        return this.baselineArmManifestLocation;
    }

    public CheckinManifestParams withBaselineArmManifestLocation(String baselineArmManifestLocation) {
        this.baselineArmManifestLocation = baselineArmManifestLocation;
        return this;
    }

    public void validate() {
        if (this.environment() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property environment in model CheckinManifestParams"));
        }
        if (this.baselineArmManifestLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property baselineArmManifestLocation in model CheckinManifestParams"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("environment", this.environment);
        jsonWriter.writeStringField("baselineArmManifestLocation", this.baselineArmManifestLocation);
        return jsonWriter.writeEndObject();
    }

    public static CheckinManifestParams fromJson(JsonReader jsonReader) throws IOException {
        return (CheckinManifestParams)jsonReader.readObject(reader -> {
            CheckinManifestParams deserializedCheckinManifestParams = new CheckinManifestParams();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("environment".equals(fieldName)) {
                    deserializedCheckinManifestParams.environment = reader.getString();
                    continue;
                }
                if ("baselineArmManifestLocation".equals(fieldName)) {
                    deserializedCheckinManifestParams.baselineArmManifestLocation = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCheckinManifestParams;
        });
    }
}

