/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ApplicationDataAuthorization;
import com.azure.resourcemanager.providerhub.models.ApplicationProviderAuthorization;
import com.azure.resourcemanager.providerhub.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class AuthorizedApplicationProperties
implements JsonSerializable<AuthorizedApplicationProperties> {
    private ApplicationProviderAuthorization providerAuthorization;
    private List<ApplicationDataAuthorization> dataAuthorizations;
    private ProvisioningState provisioningState;

    public ApplicationProviderAuthorization providerAuthorization() {
        return this.providerAuthorization;
    }

    public AuthorizedApplicationProperties withProviderAuthorization(ApplicationProviderAuthorization providerAuthorization) {
        this.providerAuthorization = providerAuthorization;
        return this;
    }

    public List<ApplicationDataAuthorization> dataAuthorizations() {
        return this.dataAuthorizations;
    }

    public AuthorizedApplicationProperties withDataAuthorizations(List<ApplicationDataAuthorization> dataAuthorizations) {
        this.dataAuthorizations = dataAuthorizations;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.providerAuthorization() != null) {
            this.providerAuthorization().validate();
        }
        if (this.dataAuthorizations() != null) {
            this.dataAuthorizations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("providerAuthorization", (JsonSerializable)this.providerAuthorization);
        jsonWriter.writeArrayField("dataAuthorizations", this.dataAuthorizations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AuthorizedApplicationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AuthorizedApplicationProperties)jsonReader.readObject(reader -> {
            AuthorizedApplicationProperties deserializedAuthorizedApplicationProperties = new AuthorizedApplicationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("providerAuthorization".equals(fieldName)) {
                    deserializedAuthorizedApplicationProperties.providerAuthorization = ApplicationProviderAuthorization.fromJson(reader);
                    continue;
                }
                if ("dataAuthorizations".equals(fieldName)) {
                    List dataAuthorizations;
                    deserializedAuthorizedApplicationProperties.dataAuthorizations = dataAuthorizations = reader.readArray(reader1 -> ApplicationDataAuthorization.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAuthorizedApplicationProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthorizedApplicationProperties;
        });
    }
}

