/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.Role;
import java.io.IOException;
import java.util.List;

public final class ApplicationDataAuthorization
implements JsonSerializable<ApplicationDataAuthorization> {
    private Role role;
    private List<String> resourceTypes;
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationDataAuthorization.class);

    public Role role() {
        return this.role;
    }

    public ApplicationDataAuthorization withRole(Role role) {
        this.role = role;
        return this;
    }

    public List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public ApplicationDataAuthorization withResourceTypes(List<String> resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    public void validate() {
        if (this.role() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property role in model ApplicationDataAuthorization"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeArrayField("resourceTypes", this.resourceTypes, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ApplicationDataAuthorization fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationDataAuthorization)jsonReader.readObject(reader -> {
            ApplicationDataAuthorization deserializedApplicationDataAuthorization = new ApplicationDataAuthorization();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("role".equals(fieldName)) {
                    deserializedApplicationDataAuthorization.role = Role.fromString(reader.getString());
                    continue;
                }
                if ("resourceTypes".equals(fieldName)) {
                    List resourceTypes;
                    deserializedApplicationDataAuthorization.resourceTypes = resourceTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationDataAuthorization;
        });
    }
}

