/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.providerhub.ProviderHubManager;
import com.azure.resourcemanager.providerhub.fluent.SkusClient;
import com.azure.resourcemanager.providerhub.fluent.models.SkuResourceInner;
import com.azure.resourcemanager.providerhub.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.providerhub.implementation.SkuResourceImpl;
import com.azure.resourcemanager.providerhub.models.SkuResource;
import com.azure.resourcemanager.providerhub.models.Skus;

public final class SkusImpl
implements Skus {
    private static final ClientLogger LOGGER = new ClientLogger(SkusImpl.class);
    private final SkusClient innerClient;
    private final ProviderHubManager serviceManager;

    public SkusImpl(SkusClient innerClient, ProviderHubManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SkuResource> getWithResponse(String providerNamespace, String resourceType, String sku, Context context) {
        Response<SkuResourceInner> inner = this.serviceClient().getWithResponse(providerNamespace, resourceType, sku, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SkuResourceImpl((SkuResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SkuResource get(String providerNamespace, String resourceType, String sku) {
        SkuResourceInner inner = this.serviceClient().get(providerNamespace, resourceType, sku);
        if (inner != null) {
            return new SkuResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String providerNamespace, String resourceType, String sku, Context context) {
        return this.serviceClient().deleteWithResponse(providerNamespace, resourceType, sku, context);
    }

    @Override
    public void delete(String providerNamespace, String resourceType, String sku) {
        this.serviceClient().delete(providerNamespace, resourceType, sku);
    }

    @Override
    public Response<SkuResource> getNestedResourceTypeFirstWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku, Context context) {
        Response<SkuResourceInner> inner = this.serviceClient().getNestedResourceTypeFirstWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, sku, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SkuResourceImpl((SkuResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SkuResource getNestedResourceTypeFirst(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku) {
        SkuResourceInner inner = this.serviceClient().getNestedResourceTypeFirst(providerNamespace, resourceType, nestedResourceTypeFirst, sku);
        if (inner != null) {
            return new SkuResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SkuResource> createOrUpdateNestedResourceTypeFirstWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku, SkuResourceInner properties, Context context) {
        Response<SkuResourceInner> inner = this.serviceClient().createOrUpdateNestedResourceTypeFirstWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, sku, properties, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SkuResourceImpl((SkuResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SkuResource createOrUpdateNestedResourceTypeFirst(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku, SkuResourceInner properties) {
        SkuResourceInner inner = this.serviceClient().createOrUpdateNestedResourceTypeFirst(providerNamespace, resourceType, nestedResourceTypeFirst, sku, properties);
        if (inner != null) {
            return new SkuResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteNestedResourceTypeFirstWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku, Context context) {
        return this.serviceClient().deleteNestedResourceTypeFirstWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, sku, context);
    }

    @Override
    public void deleteNestedResourceTypeFirst(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku) {
        this.serviceClient().deleteNestedResourceTypeFirst(providerNamespace, resourceType, nestedResourceTypeFirst, sku);
    }

    @Override
    public Response<SkuResource> getNestedResourceTypeSecondWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku, Context context) {
        Response<SkuResourceInner> inner = this.serviceClient().getNestedResourceTypeSecondWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SkuResourceImpl((SkuResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SkuResource getNestedResourceTypeSecond(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku) {
        SkuResourceInner inner = this.serviceClient().getNestedResourceTypeSecond(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku);
        if (inner != null) {
            return new SkuResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SkuResource> createOrUpdateNestedResourceTypeSecondWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku, SkuResourceInner properties, Context context) {
        Response<SkuResourceInner> inner = this.serviceClient().createOrUpdateNestedResourceTypeSecondWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku, properties, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SkuResourceImpl((SkuResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SkuResource createOrUpdateNestedResourceTypeSecond(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku, SkuResourceInner properties) {
        SkuResourceInner inner = this.serviceClient().createOrUpdateNestedResourceTypeSecond(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku, properties);
        if (inner != null) {
            return new SkuResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteNestedResourceTypeSecondWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku, Context context) {
        return this.serviceClient().deleteNestedResourceTypeSecondWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku, context);
    }

    @Override
    public void deleteNestedResourceTypeSecond(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku) {
        this.serviceClient().deleteNestedResourceTypeSecond(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku);
    }

    @Override
    public Response<SkuResource> getNestedResourceTypeThirdWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku, Context context) {
        Response<SkuResourceInner> inner = this.serviceClient().getNestedResourceTypeThirdWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SkuResourceImpl((SkuResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SkuResource getNestedResourceTypeThird(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku) {
        SkuResourceInner inner = this.serviceClient().getNestedResourceTypeThird(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku);
        if (inner != null) {
            return new SkuResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SkuResource> createOrUpdateNestedResourceTypeThirdWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku, SkuResourceInner properties, Context context) {
        Response<SkuResourceInner> inner = this.serviceClient().createOrUpdateNestedResourceTypeThirdWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku, properties, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SkuResourceImpl((SkuResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SkuResource createOrUpdateNestedResourceTypeThird(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku, SkuResourceInner properties) {
        SkuResourceInner inner = this.serviceClient().createOrUpdateNestedResourceTypeThird(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku, properties);
        if (inner != null) {
            return new SkuResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteNestedResourceTypeThirdWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku, Context context) {
        return this.serviceClient().deleteNestedResourceTypeThirdWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku, context);
    }

    @Override
    public void deleteNestedResourceTypeThird(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku) {
        this.serviceClient().deleteNestedResourceTypeThird(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku);
    }

    @Override
    public PagedIterable<SkuResource> listByResourceTypeRegistrations(String providerNamespace, String resourceType) {
        PagedIterable<SkuResourceInner> inner = this.serviceClient().listByResourceTypeRegistrations(providerNamespace, resourceType);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SkuResourceImpl((SkuResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SkuResource> listByResourceTypeRegistrations(String providerNamespace, String resourceType, Context context) {
        PagedIterable<SkuResourceInner> inner = this.serviceClient().listByResourceTypeRegistrations(providerNamespace, resourceType, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SkuResourceImpl((SkuResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SkuResource> listByResourceTypeRegistrationsNestedResourceTypeFirst(String providerNamespace, String resourceType, String nestedResourceTypeFirst) {
        PagedIterable<SkuResourceInner> inner = this.serviceClient().listByResourceTypeRegistrationsNestedResourceTypeFirst(providerNamespace, resourceType, nestedResourceTypeFirst);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SkuResourceImpl((SkuResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SkuResource> listByResourceTypeRegistrationsNestedResourceTypeFirst(String providerNamespace, String resourceType, String nestedResourceTypeFirst, Context context) {
        PagedIterable<SkuResourceInner> inner = this.serviceClient().listByResourceTypeRegistrationsNestedResourceTypeFirst(providerNamespace, resourceType, nestedResourceTypeFirst, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SkuResourceImpl((SkuResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SkuResource> listByResourceTypeRegistrationsNestedResourceTypeSecond(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond) {
        PagedIterable<SkuResourceInner> inner = this.serviceClient().listByResourceTypeRegistrationsNestedResourceTypeSecond(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SkuResourceImpl((SkuResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SkuResource> listByResourceTypeRegistrationsNestedResourceTypeSecond(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, Context context) {
        PagedIterable<SkuResourceInner> inner = this.serviceClient().listByResourceTypeRegistrationsNestedResourceTypeSecond(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SkuResourceImpl((SkuResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SkuResource> listByResourceTypeRegistrationsNestedResourceTypeThird(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird) {
        PagedIterable<SkuResourceInner> inner = this.serviceClient().listByResourceTypeRegistrationsNestedResourceTypeThird(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SkuResourceImpl((SkuResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SkuResource> listByResourceTypeRegistrationsNestedResourceTypeThird(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, Context context) {
        PagedIterable<SkuResourceInner> inner = this.serviceClient().listByResourceTypeRegistrationsNestedResourceTypeThird(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SkuResourceImpl((SkuResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public SkuResource getById(String id) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String resourceType = ResourceManagerUtils.getValueFromIdByName(id, "resourcetypeRegistrations");
        if (resourceType == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcetypeRegistrations'.", id)));
        }
        String sku = ResourceManagerUtils.getValueFromIdByName(id, "skus");
        if (sku == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'skus'.", id)));
        }
        return (SkuResource)this.getWithResponse(providerNamespace, resourceType, sku, Context.NONE).getValue();
    }

    @Override
    public Response<SkuResource> getByIdWithResponse(String id, Context context) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String resourceType = ResourceManagerUtils.getValueFromIdByName(id, "resourcetypeRegistrations");
        if (resourceType == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcetypeRegistrations'.", id)));
        }
        String sku = ResourceManagerUtils.getValueFromIdByName(id, "skus");
        if (sku == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'skus'.", id)));
        }
        return this.getWithResponse(providerNamespace, resourceType, sku, context);
    }

    @Override
    public void deleteById(String id) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String resourceType = ResourceManagerUtils.getValueFromIdByName(id, "resourcetypeRegistrations");
        if (resourceType == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcetypeRegistrations'.", id)));
        }
        String sku = ResourceManagerUtils.getValueFromIdByName(id, "skus");
        if (sku == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'skus'.", id)));
        }
        this.deleteWithResponse(providerNamespace, resourceType, sku, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String resourceType = ResourceManagerUtils.getValueFromIdByName(id, "resourcetypeRegistrations");
        if (resourceType == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcetypeRegistrations'.", id)));
        }
        String sku = ResourceManagerUtils.getValueFromIdByName(id, "skus");
        if (sku == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'skus'.", id)));
        }
        return this.deleteWithResponse(providerNamespace, resourceType, sku, context);
    }

    private SkusClient serviceClient() {
        return this.innerClient;
    }

    private ProviderHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public SkuResourceImpl define(String name) {
        return new SkuResourceImpl(name, this.manager());
    }
}

