/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.providerhub.fluent.SkusClient;
import com.azure.resourcemanager.providerhub.fluent.models.SkuResourceInner;
import com.azure.resourcemanager.providerhub.implementation.ProviderHubImpl;
import com.azure.resourcemanager.providerhub.models.SkuResourceArrayResponseWithContinuation;
import reactor.core.publisher.Mono;

public final class SkusClientImpl
implements SkusClient {
    private final SkusService service;
    private final ProviderHubImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(SkusClientImpl.class);

    SkusClientImpl(ProviderHubImpl client) {
        this.service = (SkusService)RestProxy.create(SkusService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SkuResourceInner>> getWithResponseAsync(String providerNamespace, String resourceType, String sku) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (sku == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, sku, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SkuResourceInner> getAsync(String providerNamespace, String resourceType, String sku) {
        return this.getWithResponseAsync(providerNamespace, resourceType, sku).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SkuResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SkuResourceInner> getWithResponse(String providerNamespace, String resourceType, String sku, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (sku == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, sku, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SkuResourceInner get(String providerNamespace, String resourceType, String sku) {
        return (SkuResourceInner)((Object)this.getWithResponse(providerNamespace, resourceType, sku, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SkuResourceInner>> createOrUpdateWithResponseAsync(String providerNamespace, String resourceType, String sku, SkuResourceInner properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (sku == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, sku, this.client.getApiVersion(), properties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SkuResourceInner> createOrUpdateAsync(String providerNamespace, String resourceType, String sku, SkuResourceInner properties) {
        return this.createOrUpdateWithResponseAsync(providerNamespace, resourceType, sku, properties).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SkuResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SkuResourceInner> createOrUpdateWithResponse(String providerNamespace, String resourceType, String sku, SkuResourceInner properties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (sku == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, sku, this.client.getApiVersion(), properties, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SkuResourceInner createOrUpdate(String providerNamespace, String resourceType, String sku, SkuResourceInner properties) {
        return (SkuResourceInner)((Object)this.createOrUpdateWithResponse(providerNamespace, resourceType, sku, properties, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String providerNamespace, String resourceType, String sku) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (sku == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, sku, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String providerNamespace, String resourceType, String sku) {
        return this.deleteWithResponseAsync(providerNamespace, resourceType, sku).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String providerNamespace, String resourceType, String sku, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (sku == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, sku, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String providerNamespace, String resourceType, String sku) {
        this.deleteWithResponse(providerNamespace, resourceType, sku, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SkuResourceInner>> getNestedResourceTypeFirstWithResponseAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (sku == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getNestedResourceTypeFirst(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, sku, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SkuResourceInner> getNestedResourceTypeFirstAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku) {
        return this.getNestedResourceTypeFirstWithResponseAsync(providerNamespace, resourceType, nestedResourceTypeFirst, sku).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SkuResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SkuResourceInner> getNestedResourceTypeFirstWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (sku == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getNestedResourceTypeFirstSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, sku, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SkuResourceInner getNestedResourceTypeFirst(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku) {
        return (SkuResourceInner)((Object)this.getNestedResourceTypeFirstWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, sku, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SkuResourceInner>> createOrUpdateNestedResourceTypeFirstWithResponseAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku, SkuResourceInner properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (sku == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateNestedResourceTypeFirst(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, sku, this.client.getApiVersion(), properties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SkuResourceInner> createOrUpdateNestedResourceTypeFirstAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku, SkuResourceInner properties) {
        return this.createOrUpdateNestedResourceTypeFirstWithResponseAsync(providerNamespace, resourceType, nestedResourceTypeFirst, sku, properties).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SkuResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SkuResourceInner> createOrUpdateNestedResourceTypeFirstWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku, SkuResourceInner properties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (sku == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return this.service.createOrUpdateNestedResourceTypeFirstSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, sku, this.client.getApiVersion(), properties, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SkuResourceInner createOrUpdateNestedResourceTypeFirst(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku, SkuResourceInner properties) {
        return (SkuResourceInner)((Object)this.createOrUpdateNestedResourceTypeFirstWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, sku, properties, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteNestedResourceTypeFirstWithResponseAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (sku == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteNestedResourceTypeFirst(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, sku, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteNestedResourceTypeFirstAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku) {
        return this.deleteNestedResourceTypeFirstWithResponseAsync(providerNamespace, resourceType, nestedResourceTypeFirst, sku).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteNestedResourceTypeFirstWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (sku == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteNestedResourceTypeFirstSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, sku, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteNestedResourceTypeFirst(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String sku) {
        this.deleteNestedResourceTypeFirstWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, sku, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SkuResourceInner>> getNestedResourceTypeSecondWithResponseAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        if (sku == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getNestedResourceTypeSecond(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SkuResourceInner> getNestedResourceTypeSecondAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku) {
        return this.getNestedResourceTypeSecondWithResponseAsync(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SkuResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SkuResourceInner> getNestedResourceTypeSecondWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        if (sku == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getNestedResourceTypeSecondSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SkuResourceInner getNestedResourceTypeSecond(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku) {
        return (SkuResourceInner)((Object)this.getNestedResourceTypeSecondWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SkuResourceInner>> createOrUpdateNestedResourceTypeSecondWithResponseAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku, SkuResourceInner properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        if (sku == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateNestedResourceTypeSecond(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku, this.client.getApiVersion(), properties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SkuResourceInner> createOrUpdateNestedResourceTypeSecondAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku, SkuResourceInner properties) {
        return this.createOrUpdateNestedResourceTypeSecondWithResponseAsync(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku, properties).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SkuResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SkuResourceInner> createOrUpdateNestedResourceTypeSecondWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku, SkuResourceInner properties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        if (sku == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return this.service.createOrUpdateNestedResourceTypeSecondSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku, this.client.getApiVersion(), properties, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SkuResourceInner createOrUpdateNestedResourceTypeSecond(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku, SkuResourceInner properties) {
        return (SkuResourceInner)((Object)this.createOrUpdateNestedResourceTypeSecondWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku, properties, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteNestedResourceTypeSecondWithResponseAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        if (sku == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteNestedResourceTypeSecond(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteNestedResourceTypeSecondAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku) {
        return this.deleteNestedResourceTypeSecondWithResponseAsync(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteNestedResourceTypeSecondWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        if (sku == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteNestedResourceTypeSecondSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteNestedResourceTypeSecond(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String sku) {
        this.deleteNestedResourceTypeSecondWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SkuResourceInner>> getNestedResourceTypeThirdWithResponseAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        if (nestedResourceTypeThird == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeThird is required and cannot be null."));
        }
        if (sku == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getNestedResourceTypeThird(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SkuResourceInner> getNestedResourceTypeThirdAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku) {
        return this.getNestedResourceTypeThirdWithResponseAsync(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SkuResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SkuResourceInner> getNestedResourceTypeThirdWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        if (nestedResourceTypeThird == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeThird is required and cannot be null."));
        }
        if (sku == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getNestedResourceTypeThirdSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SkuResourceInner getNestedResourceTypeThird(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku) {
        return (SkuResourceInner)((Object)this.getNestedResourceTypeThirdWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SkuResourceInner>> createOrUpdateNestedResourceTypeThirdWithResponseAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku, SkuResourceInner properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        if (nestedResourceTypeThird == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeThird is required and cannot be null."));
        }
        if (sku == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateNestedResourceTypeThird(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku, this.client.getApiVersion(), properties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SkuResourceInner> createOrUpdateNestedResourceTypeThirdAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku, SkuResourceInner properties) {
        return this.createOrUpdateNestedResourceTypeThirdWithResponseAsync(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku, properties).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SkuResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SkuResourceInner> createOrUpdateNestedResourceTypeThirdWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku, SkuResourceInner properties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        if (nestedResourceTypeThird == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeThird is required and cannot be null."));
        }
        if (sku == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return this.service.createOrUpdateNestedResourceTypeThirdSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku, this.client.getApiVersion(), properties, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SkuResourceInner createOrUpdateNestedResourceTypeThird(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku, SkuResourceInner properties) {
        return (SkuResourceInner)((Object)this.createOrUpdateNestedResourceTypeThirdWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku, properties, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteNestedResourceTypeThirdWithResponseAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        if (nestedResourceTypeThird == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeThird is required and cannot be null."));
        }
        if (sku == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteNestedResourceTypeThird(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteNestedResourceTypeThirdAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku) {
        return this.deleteNestedResourceTypeThirdWithResponseAsync(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteNestedResourceTypeThirdWithResponse(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        if (nestedResourceTypeThird == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeThird is required and cannot be null."));
        }
        if (sku == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteNestedResourceTypeThirdSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteNestedResourceTypeThird(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, String sku) {
        this.deleteNestedResourceTypeThirdWithResponse(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SkuResourceInner>> listByResourceTypeRegistrationsSinglePageAsync(String providerNamespace, String resourceType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceTypeRegistrations(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SkuResourceInner> listByResourceTypeRegistrationsAsync(String providerNamespace, String resourceType) {
        return new PagedFlux(() -> this.listByResourceTypeRegistrationsSinglePageAsync(providerNamespace, resourceType), nextLink -> this.listByResourceTypeRegistrationsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SkuResourceInner> listByResourceTypeRegistrationsSinglePage(String providerNamespace, String resourceType) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SkuResourceArrayResponseWithContinuation> res = this.service.listByResourceTypeRegistrationsSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SkuResourceInner> listByResourceTypeRegistrationsSinglePage(String providerNamespace, String resourceType, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SkuResourceArrayResponseWithContinuation> res = this.service.listByResourceTypeRegistrationsSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SkuResourceInner> listByResourceTypeRegistrations(String providerNamespace, String resourceType) {
        return new PagedIterable(() -> this.listByResourceTypeRegistrationsSinglePage(providerNamespace, resourceType), nextLink -> this.listByResourceTypeRegistrationsNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SkuResourceInner> listByResourceTypeRegistrations(String providerNamespace, String resourceType, Context context) {
        return new PagedIterable(() -> this.listByResourceTypeRegistrationsSinglePage(providerNamespace, resourceType, context), nextLink -> this.listByResourceTypeRegistrationsNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SkuResourceInner>> listByResourceTypeRegistrationsNestedResourceTypeFirstSinglePageAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceTypeRegistrationsNestedResourceTypeFirst(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeFirstAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst) {
        return new PagedFlux(() -> this.listByResourceTypeRegistrationsNestedResourceTypeFirstSinglePageAsync(providerNamespace, resourceType, nestedResourceTypeFirst), nextLink -> this.listByResourceTypeRegistrationsNestedResourceTypeFirstNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeFirstSinglePage(String providerNamespace, String resourceType, String nestedResourceTypeFirst) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SkuResourceArrayResponseWithContinuation> res = this.service.listByResourceTypeRegistrationsNestedResourceTypeFirstSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeFirstSinglePage(String providerNamespace, String resourceType, String nestedResourceTypeFirst, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SkuResourceArrayResponseWithContinuation> res = this.service.listByResourceTypeRegistrationsNestedResourceTypeFirstSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeFirst(String providerNamespace, String resourceType, String nestedResourceTypeFirst) {
        return new PagedIterable(() -> this.listByResourceTypeRegistrationsNestedResourceTypeFirstSinglePage(providerNamespace, resourceType, nestedResourceTypeFirst), nextLink -> this.listByResourceTypeRegistrationsNestedResourceTypeFirstNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeFirst(String providerNamespace, String resourceType, String nestedResourceTypeFirst, Context context) {
        return new PagedIterable(() -> this.listByResourceTypeRegistrationsNestedResourceTypeFirstSinglePage(providerNamespace, resourceType, nestedResourceTypeFirst, context), nextLink -> this.listByResourceTypeRegistrationsNestedResourceTypeFirstNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SkuResourceInner>> listByResourceTypeRegistrationsNestedResourceTypeSecondSinglePageAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceTypeRegistrationsNestedResourceTypeSecond(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeSecondAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond) {
        return new PagedFlux(() -> this.listByResourceTypeRegistrationsNestedResourceTypeSecondSinglePageAsync(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond), nextLink -> this.listByResourceTypeRegistrationsNestedResourceTypeSecondNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeSecondSinglePage(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SkuResourceArrayResponseWithContinuation> res = this.service.listByResourceTypeRegistrationsNestedResourceTypeSecondSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeSecondSinglePage(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SkuResourceArrayResponseWithContinuation> res = this.service.listByResourceTypeRegistrationsNestedResourceTypeSecondSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeSecond(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond) {
        return new PagedIterable(() -> this.listByResourceTypeRegistrationsNestedResourceTypeSecondSinglePage(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond), nextLink -> this.listByResourceTypeRegistrationsNestedResourceTypeSecondNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeSecond(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, Context context) {
        return new PagedIterable(() -> this.listByResourceTypeRegistrationsNestedResourceTypeSecondSinglePage(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, context), nextLink -> this.listByResourceTypeRegistrationsNestedResourceTypeSecondNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SkuResourceInner>> listByResourceTypeRegistrationsNestedResourceTypeThirdSinglePageAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        if (nestedResourceTypeThird == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nestedResourceTypeThird is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceTypeRegistrationsNestedResourceTypeThird(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeThirdAsync(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird) {
        return new PagedFlux(() -> this.listByResourceTypeRegistrationsNestedResourceTypeThirdSinglePageAsync(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird), nextLink -> this.listByResourceTypeRegistrationsNestedResourceTypeThirdNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeThirdSinglePage(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        if (nestedResourceTypeThird == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeThird is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SkuResourceArrayResponseWithContinuation> res = this.service.listByResourceTypeRegistrationsNestedResourceTypeThirdSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeThirdSinglePage(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (nestedResourceTypeFirst == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeFirst is required and cannot be null."));
        }
        if (nestedResourceTypeSecond == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeSecond is required and cannot be null."));
        }
        if (nestedResourceTypeThird == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nestedResourceTypeThird is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SkuResourceArrayResponseWithContinuation> res = this.service.listByResourceTypeRegistrationsNestedResourceTypeThirdSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeThird(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird) {
        return new PagedIterable(() -> this.listByResourceTypeRegistrationsNestedResourceTypeThirdSinglePage(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird), nextLink -> this.listByResourceTypeRegistrationsNestedResourceTypeThirdNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeThird(String providerNamespace, String resourceType, String nestedResourceTypeFirst, String nestedResourceTypeSecond, String nestedResourceTypeThird, Context context) {
        return new PagedIterable(() -> this.listByResourceTypeRegistrationsNestedResourceTypeThirdSinglePage(providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, context), nextLink -> this.listByResourceTypeRegistrationsNestedResourceTypeThirdNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SkuResourceInner>> listByResourceTypeRegistrationsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceTypeRegistrationsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SkuResourceInner> listByResourceTypeRegistrationsNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SkuResourceArrayResponseWithContinuation> res = this.service.listByResourceTypeRegistrationsNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SkuResourceInner> listByResourceTypeRegistrationsNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SkuResourceArrayResponseWithContinuation> res = this.service.listByResourceTypeRegistrationsNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SkuResourceInner>> listByResourceTypeRegistrationsNestedResourceTypeFirstNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceTypeRegistrationsNestedResourceTypeFirstNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeFirstNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SkuResourceArrayResponseWithContinuation> res = this.service.listByResourceTypeRegistrationsNestedResourceTypeFirstNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeFirstNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SkuResourceArrayResponseWithContinuation> res = this.service.listByResourceTypeRegistrationsNestedResourceTypeFirstNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SkuResourceInner>> listByResourceTypeRegistrationsNestedResourceTypeSecondNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceTypeRegistrationsNestedResourceTypeSecondNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeSecondNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SkuResourceArrayResponseWithContinuation> res = this.service.listByResourceTypeRegistrationsNestedResourceTypeSecondNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeSecondNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SkuResourceArrayResponseWithContinuation> res = this.service.listByResourceTypeRegistrationsNestedResourceTypeSecondNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SkuResourceInner>> listByResourceTypeRegistrationsNestedResourceTypeThirdNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceTypeRegistrationsNestedResourceTypeThirdNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeThirdNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SkuResourceArrayResponseWithContinuation> res = this.service.listByResourceTypeRegistrationsNestedResourceTypeThirdNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SkuResourceInner> listByResourceTypeRegistrationsNestedResourceTypeThirdNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SkuResourceArrayResponseWithContinuation> res = this.service.listByResourceTypeRegistrationsNestedResourceTypeThirdNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).value(), ((SkuResourceArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ProviderHubSkus")
    public static interface SkusService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/skus/{sku}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SkuResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="sku") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/skus/{sku}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SkuResourceInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="sku") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/skus/{sku}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SkuResourceInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="sku") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") SkuResourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/skus/{sku}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SkuResourceInner> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="sku") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") SkuResourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/skus/{sku}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="sku") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/skus/{sku}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="sku") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/skus/{sku}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SkuResourceInner>> getNestedResourceTypeFirst(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="sku") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/skus/{sku}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SkuResourceInner> getNestedResourceTypeFirstSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="sku") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/skus/{sku}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SkuResourceInner>> createOrUpdateNestedResourceTypeFirst(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="sku") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") SkuResourceInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/skus/{sku}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SkuResourceInner> createOrUpdateNestedResourceTypeFirstSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="sku") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") SkuResourceInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/skus/{sku}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> deleteNestedResourceTypeFirst(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="sku") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/skus/{sku}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> deleteNestedResourceTypeFirstSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="sku") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/skus/{sku}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SkuResourceInner>> getNestedResourceTypeSecond(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="nestedResourceTypeSecond") String var6, @PathParam(value="sku") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/skus/{sku}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SkuResourceInner> getNestedResourceTypeSecondSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="nestedResourceTypeSecond") String var6, @PathParam(value="sku") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/skus/{sku}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SkuResourceInner>> createOrUpdateNestedResourceTypeSecond(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="nestedResourceTypeSecond") String var6, @PathParam(value="sku") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") SkuResourceInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/skus/{sku}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SkuResourceInner> createOrUpdateNestedResourceTypeSecondSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="nestedResourceTypeSecond") String var6, @PathParam(value="sku") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") SkuResourceInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/skus/{sku}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> deleteNestedResourceTypeSecond(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="nestedResourceTypeSecond") String var6, @PathParam(value="sku") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/skus/{sku}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> deleteNestedResourceTypeSecondSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="nestedResourceTypeSecond") String var6, @PathParam(value="sku") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/resourcetypeRegistrations/{nestedResourceTypeThird}/skus/{sku}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SkuResourceInner>> getNestedResourceTypeThird(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="nestedResourceTypeSecond") String var6, @PathParam(value="nestedResourceTypeThird") String var7, @PathParam(value="sku") String var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/resourcetypeRegistrations/{nestedResourceTypeThird}/skus/{sku}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SkuResourceInner> getNestedResourceTypeThirdSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="nestedResourceTypeSecond") String var6, @PathParam(value="nestedResourceTypeThird") String var7, @PathParam(value="sku") String var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/resourcetypeRegistrations/{nestedResourceTypeThird}/skus/{sku}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SkuResourceInner>> createOrUpdateNestedResourceTypeThird(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="nestedResourceTypeSecond") String var6, @PathParam(value="nestedResourceTypeThird") String var7, @PathParam(value="sku") String var8, @QueryParam(value="api-version") String var9, @BodyParam(value="application/json") SkuResourceInner var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/resourcetypeRegistrations/{nestedResourceTypeThird}/skus/{sku}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SkuResourceInner> createOrUpdateNestedResourceTypeThirdSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="nestedResourceTypeSecond") String var6, @PathParam(value="nestedResourceTypeThird") String var7, @PathParam(value="sku") String var8, @QueryParam(value="api-version") String var9, @BodyParam(value="application/json") SkuResourceInner var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/resourcetypeRegistrations/{nestedResourceTypeThird}/skus/{sku}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> deleteNestedResourceTypeThird(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="nestedResourceTypeSecond") String var6, @PathParam(value="nestedResourceTypeThird") String var7, @PathParam(value="sku") String var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/resourcetypeRegistrations/{nestedResourceTypeThird}/skus/{sku}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> deleteNestedResourceTypeThirdSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="nestedResourceTypeSecond") String var6, @PathParam(value="nestedResourceTypeThird") String var7, @PathParam(value="sku") String var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/skus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SkuResourceArrayResponseWithContinuation>> listByResourceTypeRegistrations(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/skus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SkuResourceArrayResponseWithContinuation> listByResourceTypeRegistrationsSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/skus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SkuResourceArrayResponseWithContinuation>> listByResourceTypeRegistrationsNestedResourceTypeFirst(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/skus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SkuResourceArrayResponseWithContinuation> listByResourceTypeRegistrationsNestedResourceTypeFirstSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/skus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SkuResourceArrayResponseWithContinuation>> listByResourceTypeRegistrationsNestedResourceTypeSecond(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="nestedResourceTypeSecond") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/skus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SkuResourceArrayResponseWithContinuation> listByResourceTypeRegistrationsNestedResourceTypeSecondSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="nestedResourceTypeSecond") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/resourcetypeRegistrations/{nestedResourceTypeThird}/skus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SkuResourceArrayResponseWithContinuation>> listByResourceTypeRegistrationsNestedResourceTypeThird(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="nestedResourceTypeSecond") String var6, @PathParam(value="nestedResourceTypeThird") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/resourcetypeRegistrations/{nestedResourceTypeThird}/skus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SkuResourceArrayResponseWithContinuation> listByResourceTypeRegistrationsNestedResourceTypeThirdSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="resourceType") String var4, @PathParam(value="nestedResourceTypeFirst") String var5, @PathParam(value="nestedResourceTypeSecond") String var6, @PathParam(value="nestedResourceTypeThird") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SkuResourceArrayResponseWithContinuation>> listByResourceTypeRegistrationsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SkuResourceArrayResponseWithContinuation> listByResourceTypeRegistrationsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SkuResourceArrayResponseWithContinuation>> listByResourceTypeRegistrationsNestedResourceTypeFirstNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SkuResourceArrayResponseWithContinuation> listByResourceTypeRegistrationsNestedResourceTypeFirstNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SkuResourceArrayResponseWithContinuation>> listByResourceTypeRegistrationsNestedResourceTypeSecondNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SkuResourceArrayResponseWithContinuation> listByResourceTypeRegistrationsNestedResourceTypeSecondNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SkuResourceArrayResponseWithContinuation>> listByResourceTypeRegistrationsNestedResourceTypeThirdNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SkuResourceArrayResponseWithContinuation> listByResourceTypeRegistrationsNestedResourceTypeThirdNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

