/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.providerhub.ProviderHubManager;
import com.azure.resourcemanager.providerhub.fluent.models.SkuResourceInner;
import com.azure.resourcemanager.providerhub.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.providerhub.models.SkuResource;
import com.azure.resourcemanager.providerhub.models.SkuResourceProperties;

public final class SkuResourceImpl
implements SkuResource,
SkuResource.Definition,
SkuResource.Update {
    private SkuResourceInner innerObject;
    private final ProviderHubManager serviceManager;
    private String providerNamespace;
    private String resourceType;
    private String sku;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SkuResourceProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public SkuResourceInner innerModel() {
        return this.innerObject;
    }

    private ProviderHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public SkuResourceImpl withExistingResourcetypeRegistration(String providerNamespace, String resourceType) {
        this.providerNamespace = providerNamespace;
        this.resourceType = resourceType;
        return this;
    }

    @Override
    public SkuResource create() {
        this.innerObject = (SkuResourceInner)((Object)this.serviceManager.serviceClient().getSkus().createOrUpdateWithResponse(this.providerNamespace, this.resourceType, this.sku, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public SkuResource create(Context context) {
        this.innerObject = (SkuResourceInner)((Object)this.serviceManager.serviceClient().getSkus().createOrUpdateWithResponse(this.providerNamespace, this.resourceType, this.sku, this.innerModel(), context).getValue());
        return this;
    }

    SkuResourceImpl(String name, ProviderHubManager serviceManager) {
        this.innerObject = new SkuResourceInner();
        this.serviceManager = serviceManager;
        this.sku = name;
    }

    @Override
    public SkuResourceImpl update() {
        return this;
    }

    @Override
    public SkuResource apply() {
        this.innerObject = (SkuResourceInner)((Object)this.serviceManager.serviceClient().getSkus().createOrUpdateWithResponse(this.providerNamespace, this.resourceType, this.sku, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public SkuResource apply(Context context) {
        this.innerObject = (SkuResourceInner)((Object)this.serviceManager.serviceClient().getSkus().createOrUpdateWithResponse(this.providerNamespace, this.resourceType, this.sku, this.innerModel(), context).getValue());
        return this;
    }

    SkuResourceImpl(SkuResourceInner innerObject, ProviderHubManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.providerNamespace = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "providerRegistrations");
        this.resourceType = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourcetypeRegistrations");
        this.sku = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "skus");
    }

    @Override
    public SkuResource refresh() {
        this.innerObject = (SkuResourceInner)((Object)this.serviceManager.serviceClient().getSkus().getWithResponse(this.providerNamespace, this.resourceType, this.sku, Context.NONE).getValue());
        return this;
    }

    @Override
    public SkuResource refresh(Context context) {
        this.innerObject = (SkuResourceInner)((Object)this.serviceManager.serviceClient().getSkus().getWithResponse(this.providerNamespace, this.resourceType, this.sku, context).getValue());
        return this;
    }

    @Override
    public SkuResourceImpl withProperties(SkuResourceProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

