/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.providerhub.ProviderHubManager;
import com.azure.resourcemanager.providerhub.fluent.ResourceTypeRegistrationsClient;
import com.azure.resourcemanager.providerhub.fluent.models.ResourceTypeRegistrationInner;
import com.azure.resourcemanager.providerhub.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.providerhub.implementation.ResourceTypeRegistrationImpl;
import com.azure.resourcemanager.providerhub.models.ResourceTypeRegistration;
import com.azure.resourcemanager.providerhub.models.ResourceTypeRegistrations;

public final class ResourceTypeRegistrationsImpl
implements ResourceTypeRegistrations {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceTypeRegistrationsImpl.class);
    private final ResourceTypeRegistrationsClient innerClient;
    private final ProviderHubManager serviceManager;

    public ResourceTypeRegistrationsImpl(ResourceTypeRegistrationsClient innerClient, ProviderHubManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ResourceTypeRegistration> getWithResponse(String providerNamespace, String resourceType, Context context) {
        Response<ResourceTypeRegistrationInner> inner = this.serviceClient().getWithResponse(providerNamespace, resourceType, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ResourceTypeRegistrationImpl((ResourceTypeRegistrationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ResourceTypeRegistration get(String providerNamespace, String resourceType) {
        ResourceTypeRegistrationInner inner = this.serviceClient().get(providerNamespace, resourceType);
        if (inner != null) {
            return new ResourceTypeRegistrationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String providerNamespace, String resourceType) {
        this.serviceClient().delete(providerNamespace, resourceType);
    }

    @Override
    public void delete(String providerNamespace, String resourceType, Context context) {
        this.serviceClient().delete(providerNamespace, resourceType, context);
    }

    @Override
    public PagedIterable<ResourceTypeRegistration> listByProviderRegistration(String providerNamespace) {
        PagedIterable<ResourceTypeRegistrationInner> inner = this.serviceClient().listByProviderRegistration(providerNamespace);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceTypeRegistrationImpl((ResourceTypeRegistrationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ResourceTypeRegistration> listByProviderRegistration(String providerNamespace, Context context) {
        PagedIterable<ResourceTypeRegistrationInner> inner = this.serviceClient().listByProviderRegistration(providerNamespace, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceTypeRegistrationImpl((ResourceTypeRegistrationInner)((Object)inner1), this.manager()));
    }

    @Override
    public ResourceTypeRegistration getById(String id) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String resourceType = ResourceManagerUtils.getValueFromIdByName(id, "resourcetypeRegistrations");
        if (resourceType == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcetypeRegistrations'.", id)));
        }
        return (ResourceTypeRegistration)this.getWithResponse(providerNamespace, resourceType, Context.NONE).getValue();
    }

    @Override
    public Response<ResourceTypeRegistration> getByIdWithResponse(String id, Context context) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String resourceType = ResourceManagerUtils.getValueFromIdByName(id, "resourcetypeRegistrations");
        if (resourceType == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcetypeRegistrations'.", id)));
        }
        return this.getWithResponse(providerNamespace, resourceType, context);
    }

    @Override
    public void deleteById(String id) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String resourceType = ResourceManagerUtils.getValueFromIdByName(id, "resourcetypeRegistrations");
        if (resourceType == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcetypeRegistrations'.", id)));
        }
        this.delete(providerNamespace, resourceType, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String resourceType = ResourceManagerUtils.getValueFromIdByName(id, "resourcetypeRegistrations");
        if (resourceType == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcetypeRegistrations'.", id)));
        }
        this.delete(providerNamespace, resourceType, context);
    }

    private ResourceTypeRegistrationsClient serviceClient() {
        return this.innerClient;
    }

    private ProviderHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public ResourceTypeRegistrationImpl define(String name) {
        return new ResourceTypeRegistrationImpl(name, this.manager());
    }
}

