/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.providerhub.ProviderHubManager;
import com.azure.resourcemanager.providerhub.fluent.models.ResourceTypeRegistrationInner;
import com.azure.resourcemanager.providerhub.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.providerhub.models.ResourceTypeRegistration;
import com.azure.resourcemanager.providerhub.models.ResourceTypeRegistrationKind;
import com.azure.resourcemanager.providerhub.models.ResourceTypeRegistrationProperties;

public final class ResourceTypeRegistrationImpl
implements ResourceTypeRegistration,
ResourceTypeRegistration.Definition,
ResourceTypeRegistration.Update {
    private ResourceTypeRegistrationInner innerObject;
    private final ProviderHubManager serviceManager;
    private String providerNamespace;
    private String resourceType;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ResourceTypeRegistrationProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ResourceTypeRegistrationKind kind() {
        return this.innerModel().kind();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ResourceTypeRegistrationInner innerModel() {
        return this.innerObject;
    }

    private ProviderHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public ResourceTypeRegistrationImpl withExistingProviderRegistration(String providerNamespace) {
        this.providerNamespace = providerNamespace;
        return this;
    }

    @Override
    public ResourceTypeRegistration create() {
        this.innerObject = this.serviceManager.serviceClient().getResourceTypeRegistrations().createOrUpdate(this.providerNamespace, this.resourceType, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ResourceTypeRegistration create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getResourceTypeRegistrations().createOrUpdate(this.providerNamespace, this.resourceType, this.innerModel(), context);
        return this;
    }

    ResourceTypeRegistrationImpl(String name, ProviderHubManager serviceManager) {
        this.innerObject = new ResourceTypeRegistrationInner();
        this.serviceManager = serviceManager;
        this.resourceType = name;
    }

    @Override
    public ResourceTypeRegistrationImpl update() {
        return this;
    }

    @Override
    public ResourceTypeRegistration apply() {
        this.innerObject = this.serviceManager.serviceClient().getResourceTypeRegistrations().createOrUpdate(this.providerNamespace, this.resourceType, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ResourceTypeRegistration apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getResourceTypeRegistrations().createOrUpdate(this.providerNamespace, this.resourceType, this.innerModel(), context);
        return this;
    }

    ResourceTypeRegistrationImpl(ResourceTypeRegistrationInner innerObject, ProviderHubManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.providerNamespace = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "providerRegistrations");
        this.resourceType = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourcetypeRegistrations");
    }

    @Override
    public ResourceTypeRegistration refresh() {
        this.innerObject = (ResourceTypeRegistrationInner)((Object)this.serviceManager.serviceClient().getResourceTypeRegistrations().getWithResponse(this.providerNamespace, this.resourceType, Context.NONE).getValue());
        return this;
    }

    @Override
    public ResourceTypeRegistration refresh(Context context) {
        this.innerObject = (ResourceTypeRegistrationInner)((Object)this.serviceManager.serviceClient().getResourceTypeRegistrations().getWithResponse(this.providerNamespace, this.resourceType, context).getValue());
        return this;
    }

    @Override
    public ResourceTypeRegistrationImpl withProperties(ResourceTypeRegistrationProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public ResourceTypeRegistrationImpl withKind(ResourceTypeRegistrationKind kind) {
        this.innerModel().withKind(kind);
        return this;
    }
}

