/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.providerhub.ProviderHubManager;
import com.azure.resourcemanager.providerhub.fluent.ProviderRegistrationsClient;
import com.azure.resourcemanager.providerhub.fluent.models.OperationsDefinitionInner;
import com.azure.resourcemanager.providerhub.fluent.models.ProviderRegistrationInner;
import com.azure.resourcemanager.providerhub.implementation.OperationsDefinitionImpl;
import com.azure.resourcemanager.providerhub.implementation.ProviderRegistrationImpl;
import com.azure.resourcemanager.providerhub.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.providerhub.models.OperationsDefinition;
import com.azure.resourcemanager.providerhub.models.ProviderRegistration;
import com.azure.resourcemanager.providerhub.models.ProviderRegistrations;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class ProviderRegistrationsImpl
implements ProviderRegistrations {
    private static final ClientLogger LOGGER = new ClientLogger(ProviderRegistrationsImpl.class);
    private final ProviderRegistrationsClient innerClient;
    private final ProviderHubManager serviceManager;

    public ProviderRegistrationsImpl(ProviderRegistrationsClient innerClient, ProviderHubManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ProviderRegistration> getWithResponse(String providerNamespace, Context context) {
        Response<ProviderRegistrationInner> inner = this.serviceClient().getWithResponse(providerNamespace, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProviderRegistrationImpl((ProviderRegistrationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ProviderRegistration get(String providerNamespace) {
        ProviderRegistrationInner inner = this.serviceClient().get(providerNamespace);
        if (inner != null) {
            return new ProviderRegistrationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ProviderRegistration createOrUpdate(String providerNamespace, ProviderRegistrationInner properties) {
        ProviderRegistrationInner inner = this.serviceClient().createOrUpdate(providerNamespace, properties);
        if (inner != null) {
            return new ProviderRegistrationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ProviderRegistration createOrUpdate(String providerNamespace, ProviderRegistrationInner properties, Context context) {
        ProviderRegistrationInner inner = this.serviceClient().createOrUpdate(providerNamespace, properties, context);
        if (inner != null) {
            return new ProviderRegistrationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String providerNamespace, Context context) {
        return this.serviceClient().deleteWithResponse(providerNamespace, context);
    }

    @Override
    public void delete(String providerNamespace) {
        this.serviceClient().delete(providerNamespace);
    }

    @Override
    public PagedIterable<ProviderRegistration> list() {
        PagedIterable<ProviderRegistrationInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProviderRegistrationImpl((ProviderRegistrationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ProviderRegistration> list(Context context) {
        PagedIterable<ProviderRegistrationInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProviderRegistrationImpl((ProviderRegistrationInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<List<OperationsDefinition>> generateOperationsWithResponse(String providerNamespace, Context context) {
        Response<List<OperationsDefinitionInner>> inner = this.serviceClient().generateOperationsWithResponse(providerNamespace, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), ((List)inner.getValue()).stream().map(inner1 -> new OperationsDefinitionImpl((OperationsDefinitionInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return null;
    }

    @Override
    public List<OperationsDefinition> generateOperations(String providerNamespace) {
        List<OperationsDefinitionInner> inner = this.serviceClient().generateOperations(providerNamespace);
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new OperationsDefinitionImpl((OperationsDefinitionInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    private ProviderRegistrationsClient serviceClient() {
        return this.innerClient;
    }

    private ProviderHubManager manager() {
        return this.serviceManager;
    }
}

