/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.providerhub.ProviderHubManager;
import com.azure.resourcemanager.providerhub.fluent.ProviderMonitorSettingsClient;
import com.azure.resourcemanager.providerhub.fluent.models.ProviderMonitorSettingInner;
import com.azure.resourcemanager.providerhub.implementation.ProviderMonitorSettingImpl;
import com.azure.resourcemanager.providerhub.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.providerhub.models.ProviderMonitorSetting;
import com.azure.resourcemanager.providerhub.models.ProviderMonitorSettings;

public final class ProviderMonitorSettingsImpl
implements ProviderMonitorSettings {
    private static final ClientLogger LOGGER = new ClientLogger(ProviderMonitorSettingsImpl.class);
    private final ProviderMonitorSettingsClient innerClient;
    private final ProviderHubManager serviceManager;

    public ProviderMonitorSettingsImpl(ProviderMonitorSettingsClient innerClient, ProviderHubManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ProviderMonitorSetting> getByResourceGroupWithResponse(String resourceGroupName, String providerMonitorSettingName, Context context) {
        Response<ProviderMonitorSettingInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, providerMonitorSettingName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProviderMonitorSettingImpl((ProviderMonitorSettingInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ProviderMonitorSetting getByResourceGroup(String resourceGroupName, String providerMonitorSettingName) {
        ProviderMonitorSettingInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, providerMonitorSettingName);
        if (inner != null) {
            return new ProviderMonitorSettingImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ProviderMonitorSetting> updateWithResponse(String resourceGroupName, String providerMonitorSettingName, Context context) {
        Response<ProviderMonitorSettingInner> inner = this.serviceClient().updateWithResponse(resourceGroupName, providerMonitorSettingName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ProviderMonitorSettingImpl((ProviderMonitorSettingInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ProviderMonitorSetting update(String resourceGroupName, String providerMonitorSettingName) {
        ProviderMonitorSettingInner inner = this.serviceClient().update(resourceGroupName, providerMonitorSettingName);
        if (inner != null) {
            return new ProviderMonitorSettingImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String resourceGroupName, String providerMonitorSettingName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, providerMonitorSettingName, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String providerMonitorSettingName) {
        this.serviceClient().delete(resourceGroupName, providerMonitorSettingName);
    }

    @Override
    public PagedIterable<ProviderMonitorSetting> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ProviderMonitorSettingInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProviderMonitorSettingImpl((ProviderMonitorSettingInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ProviderMonitorSetting> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ProviderMonitorSettingInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProviderMonitorSettingImpl((ProviderMonitorSettingInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ProviderMonitorSetting> list() {
        PagedIterable<ProviderMonitorSettingInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProviderMonitorSettingImpl((ProviderMonitorSettingInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ProviderMonitorSetting> list(Context context) {
        PagedIterable<ProviderMonitorSettingInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProviderMonitorSettingImpl((ProviderMonitorSettingInner)((Object)inner1), this.manager()));
    }

    @Override
    public ProviderMonitorSetting getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String providerMonitorSettingName = ResourceManagerUtils.getValueFromIdByName(id, "providerMonitorSettings");
        if (providerMonitorSettingName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerMonitorSettings'.", id)));
        }
        return (ProviderMonitorSetting)this.getByResourceGroupWithResponse(resourceGroupName, providerMonitorSettingName, Context.NONE).getValue();
    }

    @Override
    public Response<ProviderMonitorSetting> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String providerMonitorSettingName = ResourceManagerUtils.getValueFromIdByName(id, "providerMonitorSettings");
        if (providerMonitorSettingName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerMonitorSettings'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, providerMonitorSettingName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String providerMonitorSettingName = ResourceManagerUtils.getValueFromIdByName(id, "providerMonitorSettings");
        if (providerMonitorSettingName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerMonitorSettings'.", id)));
        }
        this.deleteByResourceGroupWithResponse(resourceGroupName, providerMonitorSettingName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String providerMonitorSettingName = ResourceManagerUtils.getValueFromIdByName(id, "providerMonitorSettings");
        if (providerMonitorSettingName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerMonitorSettings'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceGroupName, providerMonitorSettingName, context);
    }

    private ProviderMonitorSettingsClient serviceClient() {
        return this.innerClient;
    }

    private ProviderHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public ProviderMonitorSettingImpl define(String name) {
        return new ProviderMonitorSettingImpl(name, this.manager());
    }
}

