/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.providerhub.ProviderHubManager;
import com.azure.resourcemanager.providerhub.fluent.models.ProviderMonitorSettingInner;
import com.azure.resourcemanager.providerhub.models.ProviderMonitorSetting;
import com.azure.resourcemanager.providerhub.models.ProviderMonitorSettingProperties;
import java.util.Collections;
import java.util.Map;

public final class ProviderMonitorSettingImpl
implements ProviderMonitorSetting,
ProviderMonitorSetting.Definition {
    private ProviderMonitorSettingInner innerObject;
    private final ProviderHubManager serviceManager;
    private String resourceGroupName;
    private String providerMonitorSettingName;

    ProviderMonitorSettingImpl(ProviderMonitorSettingInner innerObject, ProviderHubManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ProviderMonitorSettingProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public ProviderMonitorSettingInner innerModel() {
        return this.innerObject;
    }

    private ProviderHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public ProviderMonitorSettingImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ProviderMonitorSetting create() {
        this.innerObject = this.serviceManager.serviceClient().getProviderMonitorSettings().create(this.resourceGroupName, this.providerMonitorSettingName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ProviderMonitorSetting create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getProviderMonitorSettings().create(this.resourceGroupName, this.providerMonitorSettingName, this.innerModel(), context);
        return this;
    }

    ProviderMonitorSettingImpl(String name, ProviderHubManager serviceManager) {
        this.innerObject = new ProviderMonitorSettingInner();
        this.serviceManager = serviceManager;
        this.providerMonitorSettingName = name;
    }

    @Override
    public ProviderMonitorSetting refresh() {
        this.innerObject = (ProviderMonitorSettingInner)((Object)this.serviceManager.serviceClient().getProviderMonitorSettings().getByResourceGroupWithResponse(this.resourceGroupName, this.providerMonitorSettingName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ProviderMonitorSetting refresh(Context context) {
        this.innerObject = (ProviderMonitorSettingInner)((Object)this.serviceManager.serviceClient().getProviderMonitorSettings().getByResourceGroupWithResponse(this.resourceGroupName, this.providerMonitorSettingName, context).getValue());
        return this;
    }

    @Override
    public ProviderMonitorSettingImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ProviderMonitorSettingImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ProviderMonitorSettingImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public ProviderMonitorSettingImpl withProperties(ProviderMonitorSettingProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

