/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.management.polling.SyncPollerFactory;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.providerhub.fluent.AuthorizedApplicationsClient;
import com.azure.resourcemanager.providerhub.fluent.CustomRolloutsClient;
import com.azure.resourcemanager.providerhub.fluent.DefaultRolloutsClient;
import com.azure.resourcemanager.providerhub.fluent.NewRegionFrontloadReleasesClient;
import com.azure.resourcemanager.providerhub.fluent.NotificationRegistrationsClient;
import com.azure.resourcemanager.providerhub.fluent.OperationsClient;
import com.azure.resourcemanager.providerhub.fluent.ProviderHub;
import com.azure.resourcemanager.providerhub.fluent.ProviderMonitorSettingsClient;
import com.azure.resourcemanager.providerhub.fluent.ProviderRegistrationsClient;
import com.azure.resourcemanager.providerhub.fluent.ResourceActionsClient;
import com.azure.resourcemanager.providerhub.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.providerhub.fluent.ResourceTypeRegistrationsClient;
import com.azure.resourcemanager.providerhub.fluent.SkusClient;
import com.azure.resourcemanager.providerhub.implementation.AuthorizedApplicationsClientImpl;
import com.azure.resourcemanager.providerhub.implementation.CustomRolloutsClientImpl;
import com.azure.resourcemanager.providerhub.implementation.DefaultRolloutsClientImpl;
import com.azure.resourcemanager.providerhub.implementation.NewRegionFrontloadReleasesClientImpl;
import com.azure.resourcemanager.providerhub.implementation.NotificationRegistrationsClientImpl;
import com.azure.resourcemanager.providerhub.implementation.OperationsClientImpl;
import com.azure.resourcemanager.providerhub.implementation.ProviderHubBuilder;
import com.azure.resourcemanager.providerhub.implementation.ProviderMonitorSettingsClientImpl;
import com.azure.resourcemanager.providerhub.implementation.ProviderRegistrationsClientImpl;
import com.azure.resourcemanager.providerhub.implementation.ResourceActionsClientImpl;
import com.azure.resourcemanager.providerhub.implementation.ResourceProvidersClientImpl;
import com.azure.resourcemanager.providerhub.implementation.ResourceTypeRegistrationsClientImpl;
import com.azure.resourcemanager.providerhub.implementation.SkusClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ProviderHubBuilder.class)
public final class ProviderHubImpl
implements ProviderHub {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final CustomRolloutsClient customRollouts;
    private final DefaultRolloutsClient defaultRollouts;
    private final ResourceProvidersClient resourceProviders;
    private final NotificationRegistrationsClient notificationRegistrations;
    private final OperationsClient operations;
    private final ProviderRegistrationsClient providerRegistrations;
    private final ResourceTypeRegistrationsClient resourceTypeRegistrations;
    private final SkusClient skus;
    private final ResourceActionsClient resourceActions;
    private final AuthorizedApplicationsClient authorizedApplications;
    private final ProviderMonitorSettingsClient providerMonitorSettings;
    private final NewRegionFrontloadReleasesClient newRegionFrontloadReleases;
    private static final ClientLogger LOGGER = new ClientLogger(ProviderHubImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public CustomRolloutsClient getCustomRollouts() {
        return this.customRollouts;
    }

    @Override
    public DefaultRolloutsClient getDefaultRollouts() {
        return this.defaultRollouts;
    }

    @Override
    public ResourceProvidersClient getResourceProviders() {
        return this.resourceProviders;
    }

    @Override
    public NotificationRegistrationsClient getNotificationRegistrations() {
        return this.notificationRegistrations;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public ProviderRegistrationsClient getProviderRegistrations() {
        return this.providerRegistrations;
    }

    @Override
    public ResourceTypeRegistrationsClient getResourceTypeRegistrations() {
        return this.resourceTypeRegistrations;
    }

    @Override
    public SkusClient getSkus() {
        return this.skus;
    }

    @Override
    public ResourceActionsClient getResourceActions() {
        return this.resourceActions;
    }

    @Override
    public AuthorizedApplicationsClient getAuthorizedApplications() {
        return this.authorizedApplications;
    }

    @Override
    public ProviderMonitorSettingsClient getProviderMonitorSettings() {
        return this.providerMonitorSettings;
    }

    @Override
    public NewRegionFrontloadReleasesClient getNewRegionFrontloadReleases() {
        return this.newRegionFrontloadReleases;
    }

    ProviderHubImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2024-09-01";
        this.customRollouts = new CustomRolloutsClientImpl(this);
        this.defaultRollouts = new DefaultRolloutsClientImpl(this);
        this.resourceProviders = new ResourceProvidersClientImpl(this);
        this.notificationRegistrations = new NotificationRegistrationsClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.providerRegistrations = new ProviderRegistrationsClientImpl(this);
        this.resourceTypeRegistrations = new ResourceTypeRegistrationsClientImpl(this);
        this.skus = new SkusClientImpl(this);
        this.resourceActions = new ResourceActionsClientImpl(this);
        this.authorizedApplications = new AuthorizedApplicationsClientImpl(this);
        this.providerMonitorSettings = new ProviderMonitorSettingsClientImpl(this);
        this.newRegionFrontloadReleases = new NewRegionFrontloadReleasesClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> SyncPoller<PollResult<T>, U> getLroResult(Response<BinaryData> activationResponse, Type pollResultType, Type finalResultType, Context context) {
        return SyncPollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)this.httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, () -> activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

