/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.providerhub.ProviderHubManager;
import com.azure.resourcemanager.providerhub.fluent.OperationsClient;
import com.azure.resourcemanager.providerhub.fluent.models.OperationsDefinitionInner;
import com.azure.resourcemanager.providerhub.fluent.models.OperationsPutContentInner;
import com.azure.resourcemanager.providerhub.implementation.OperationsDefinitionImpl;
import com.azure.resourcemanager.providerhub.implementation.OperationsPutContentImpl;
import com.azure.resourcemanager.providerhub.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.providerhub.models.Operations;
import com.azure.resourcemanager.providerhub.models.OperationsDefinition;
import com.azure.resourcemanager.providerhub.models.OperationsPutContent;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class OperationsImpl
implements Operations {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsImpl.class);
    private final OperationsClient innerClient;
    private final ProviderHubManager serviceManager;

    public OperationsImpl(OperationsClient innerClient, ProviderHubManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<OperationsDefinition> list() {
        PagedIterable<OperationsDefinitionInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationsDefinitionImpl((OperationsDefinitionInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<OperationsDefinition> list(Context context) {
        PagedIterable<OperationsDefinitionInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationsDefinitionImpl((OperationsDefinitionInner)inner1, this.manager()));
    }

    @Override
    public Response<List<OperationsDefinition>> listByProviderRegistrationWithResponse(String providerNamespace, Context context) {
        Response<List<OperationsDefinitionInner>> inner = this.serviceClient().listByProviderRegistrationWithResponse(providerNamespace, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), ((List)inner.getValue()).stream().map(inner1 -> new OperationsDefinitionImpl((OperationsDefinitionInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return null;
    }

    @Override
    public List<OperationsDefinition> listByProviderRegistration(String providerNamespace) {
        List<OperationsDefinitionInner> inner = this.serviceClient().listByProviderRegistration(providerNamespace);
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new OperationsDefinitionImpl((OperationsDefinitionInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public Response<OperationsPutContent> createOrUpdateWithResponse(String providerNamespace, OperationsPutContentInner operationsPutContent, Context context) {
        Response<OperationsPutContentInner> inner = this.serviceClient().createOrUpdateWithResponse(providerNamespace, operationsPutContent, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OperationsPutContentImpl((OperationsPutContentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public OperationsPutContent createOrUpdate(String providerNamespace, OperationsPutContentInner operationsPutContent) {
        OperationsPutContentInner inner = this.serviceClient().createOrUpdate(providerNamespace, operationsPutContent);
        if (inner != null) {
            return new OperationsPutContentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String providerNamespace, Context context) {
        return this.serviceClient().deleteWithResponse(providerNamespace, context);
    }

    @Override
    public void delete(String providerNamespace) {
        this.serviceClient().delete(providerNamespace);
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private ProviderHubManager manager() {
        return this.serviceManager;
    }
}

